% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.r
\name{tidy_matrix}
\alias{tidy_matrix}
\alias{add_statistic}
\alias{symbol}
\alias{expect_equal_models}
\alias{write_test_stats}
\title{Helper functions in tidystats}
\usage{
tidy_matrix(m, symmetric = TRUE)

add_statistic(
  list,
  name,
  value,
  symbol = NULL,
  subscript = NULL,
  interval = NULL,
  level = NULL,
  lower = NULL,
  upper = NULL
)

symbol(
  x = c("alpha", "chi_squared", "delta", "guttmans_lambda", "K_squared", "lambda",
    "p_hat", "R_squared", "sigma", "t_squared", "tau")
)

expect_equal_models(model, expected_tidy_model, tolerance = 0.001)

write_test_stats(x, path, digits = 6)
}
\arguments{
\item{m}{A matrix.}
}
\description{
Functions used under the hood in the tidystats package.
}
\section{Functions}{
\itemize{
\item \code{tidy_matrix()}: Function to convert matrix objects to a tidy data frame.

\item \code{add_statistic()}: Function to add a statistic to list. It helps create the list and ignores
NULL values.

\item \code{symbol()}: Function to return symbols in ASCII.

\item \code{expect_equal_models()}: Function to compare tidied models during testing.

\item \code{write_test_stats()}: Function to save tidied statistics to a file. Since these files are used
during testing, it's important to only store files with correctly tidied
statistics, hence the prompt.

}}
\keyword{internal}
