% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select.R
\name{select.}
\alias{select.}
\alias{dt_select}
\title{Select or drop columns}
\usage{
select.(.data, ...)

dt_select(.data, ...)
}
\arguments{
\item{.data}{A data.frame or data.table}

\item{...}{Columns to select or drop}
}
\description{
Select or drop columns from a data.table

Supports enhanced selection
}
\examples{
example_dt <- data.table::data.table(
  x = c(1,1,1),
  y = c(4,5,6),
  double_x = c(2,2,2),
  z = c("a","a","b"))

example_dt \%>\%
  select.(x, y)

example_dt \%>\%
  select.(x:z)

example_dt \%>\%
  select.(-y, -z)

example_dt \%>\%
  select.(starts_with.("x"), z)

example_dt \%>\%
  select.(is.character, x)
}
