% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cur_group.R
\name{cur_group_id.}
\alias{cur_group_id.}
\alias{cur_group_rows.}
\title{Current group context}
\usage{
cur_group_id.()

cur_group_rows.()
}
\description{
These functions give information about the "current" group.
\itemize{
\item \code{cur_group_id.()} gives a group identification number
\item \code{cur_group_rows.()} gives the row indices for each group
}

Can be used inside \code{summarize.()}, \code{mutate.()}, & \code{filter.()}
}
\examples{
df <- data.table(
  x = 1:5,
  y = c("a", "a", "a", "b", "b")
)

df \%>\%
  mutate.(group_id = cur_group_id.(),
          .by = y)

df \%>\%
  mutate.(group_rows = cur_group_rows.(),
          .by = y)
}
