% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join.R
\name{nest_join}
\alias{nest_join}
\title{Nest join}
\usage{
nest_join(x, y, by = NULL, keep = FALSE, name = NULL, ...)
}
\arguments{
\item{x}{A data.frame or data.table}

\item{y}{A data.frame or data.table}

\item{by}{A character vector of variables to join by. If NULL, the default, the join will do a natural join, using all variables with common names across the two tables.}

\item{keep}{Should the join keys from both \code{x} and \code{y} be preserved in the output?}

\item{name}{The name of the list-column created by the join. If \code{NULL} the name of \code{y} is used.}

\item{...}{Other parameters passed on to methods}
}
\description{
Join the data from y as a list column onto x.
}
\examples{
df1 <- tidytable(x = 1:3)
df2 <- tidytable(x = c(2, 3, 3), y = c("a", "b", "c"))

out <- nest_join(df1, df2)
out
out$df2
}
