% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scales_whitebox.R
\name{scale_whitebox}
\alias{scale_whitebox}
\alias{scale_fill_whitebox_d}
\alias{scale_colour_whitebox_d}
\alias{scale_fill_whitebox_c}
\alias{scale_colour_whitebox_c}
\alias{scale_fill_whitebox_b}
\alias{scale_colour_whitebox_b}
\alias{whitebox.colors}
\alias{scale_color_whitebox_d}
\alias{scale_color_whitebox_c}
\alias{scale_color_whitebox_b}
\title{Gradient scales from WhiteboxTools color schemes}
\source{
\url{https://github.com/jblindsay/whitebox-tools}, under
MIT License. Copyright (c) 2017-2021 John Lindsay.
}
\usage{
scale_fill_whitebox_d(palette = "high_relief", ..., alpha = 1, direction = 1)

scale_colour_whitebox_d(palette = "high_relief", ..., alpha = 1, direction = 1)

scale_fill_whitebox_c(
  palette = "high_relief",
  ...,
  alpha = 1,
  direction = 1,
  na.value = NA,
  guide = "colourbar"
)

scale_colour_whitebox_c(
  palette = "high_relief",
  ...,
  alpha = 1,
  direction = 1,
  na.value = NA,
  guide = "colourbar"
)

scale_fill_whitebox_b(
  palette = "high_relief",
  ...,
  alpha = 1,
  direction = 1,
  na.value = NA,
  guide = "coloursteps"
)

scale_colour_whitebox_b(
  palette = "high_relief",
  ...,
  alpha = 1,
  direction = 1,
  na.value = NA,
  guide = "coloursteps"
)

whitebox.colors(n, palette = "high_relief", alpha = 1, rev = FALSE)
}
\arguments{
\item{palette}{A valid palette name. The name is matched to the list of
available palettes, ignoring upper vs. lower case. Values available are:
\code{"atlas"}, \code{"high_relief"}, \code{"arid"}, \code{"soft"}, \code{"muted"}, \code{"purple"}, \code{"viridi"}, \code{"gn_yl"}, \code{"pi_y_g"}, \code{"bl_yl_rd"}, \code{"deep"}.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:discrete_scale]{discrete_scale()}},
\code{\link[ggplot2:continuous_scale]{continuous_scale()}}, or \code{\link[ggplot2:binned_scale]{binned_scale()}} to control name, limits, breaks,
labels and so forth.}

\item{alpha}{The alpha transparency, a number in [0,1], see argument alpha in
\code{\link[grDevices]{hsv}}.}

\item{direction}{Sets the order of colors in the scale. If 1, the default,
colors are ordered from darkest to lightest. If -1, the order of colors is
reversed.}

\item{na.value}{Missing values will be replaced with this value.}

\item{guide}{A function used to create a guide or its name. See
\code{\link[ggplot2:guides]{guides()}} for more information.}

\item{n}{the number of colors (\eqn{\ge 1}) to be in the
    palette.}

\item{rev}{logical indicating whether the ordering of the colors should
    be reversed.}
}
\value{
The corresponding ggplot2 layer with the values applied to the
\code{fill/colour} aesthetics.
}
\description{
Implementation of the gradient palettes provided by
\href{https://github.com/jblindsay/whitebox-tools}{WhiteboxTools}. Three
scales are provided:
\itemize{
\item \verb{scale_*_whitebox_d()}: For discrete values.
\item \verb{scale_*_whitebox_c()}: For continuous values.
\item \verb{scale_*_whitebox_b()}: For binning continuous values.
}

Additionally, a color palette \code{whitebox.colors()} is provided. See also
\code{\link[grDevices:palettes]{grDevices::terrain.colors()}} for details.
}
\examples{
\donttest{
filepath <- system.file("extdata/volcano2.tif", package = "tidyterra")

library(terra)
volcano2_rast <- rast(filepath)

# Palette
plot(volcano2_rast, col = whitebox.colors(100))

library(ggplot2)
ggplot() +
  geom_spatraster(data = volcano2_rast) +
  scale_fill_whitebox_c()

# Binned
ggplot() +
  geom_spatraster(data = volcano2_rast) +
  scale_fill_whitebox_b(breaks = seq(70, 200, 10), palette = "atlas")

# With discrete values
factor <- volcano2_rast \%>\% mutate(cats = cut(elevation,
  breaks = c(100, 120, 130, 150, 170, 200),
  labels = c(
    "Very Low", "Low", "Average", "High",
    "Very High"
  )
))


ggplot() +
  geom_spatraster(data = factor, aes(fill = cats)) +
  scale_fill_whitebox_d(na.value = "gray10", palette = "soft")
}

# Display all the whitebox palettes

pals <- c(
  "atlas", "high_relief", "arid", "soft", "muted", "purple",
  "viridi", "gn_yl", "pi_y_g", "bl_yl_rd", "deep"
)

# Helper fun for plotting

ncols <- 128
rowcol <- grDevices::n2mfrow(length(pals))

opar <- par(no.readonly = TRUE)
par(mfrow = rowcol, mar = rep(1, 4))

for (i in pals) {
  image(
    x = seq(1, ncols), y = 1, z = as.matrix(seq(1, ncols)),
    col = whitebox.colors(ncols, i), main = i,
    ylab = "", xaxt = "n", yaxt = "n", bty = "n"
  )
}
par(opar)
}
\seealso{
\code{\link[terra:plot]{terra::plot()}}, \code{\link[ggplot2:scale_viridis]{ggplot2::scale_fill_viridis_c()}}

Other gradient scales and palettes for hypsometry:
\code{\link{scale_cross_blended}},
\code{\link{scale_hypso}},
\code{\link{scale_terrain}},
\code{\link{scale_wiki}}
}
\concept{gradients}
