% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/na.R
\name{first_non_nas}
\alias{first_non_nas}
\title{Row-wise first value which is not NA}
\usage{
first_non_nas(...)
}
\arguments{
\item{...}{multiple vectors of same type and size, regarded as columns}
}
\value{
Returns a vector of type and size as any of the given vectors
        (vectors regarded a column, number of rows is size of each vectors)
        For each "row", returns the first value that is not NA, or NA iff all values in the row are NA.
}
\description{
This is useful in conjunction with dplyr's mutate to condense multiple columns to one,
where in each sample typically only one of n columns has a value, while the others are NA.
Returns one vector of the same length as each input vector containing the result.
Note that factors will be converted to character vectors (with a warning).
}
\examples{
library(tibble)
library(magrittr)
library(dplyr)
# Creates a column containing (4, 2, 2)
tibble(a=c(NA, NA, 2), b=c(4, NA, 5), c=c(1, 2, 3)) \%>\%
  mutate(essence=first_non_nas(a, b, c))
}
