test_that("univar works with .ord as expected", {
  mtcars2 <- mtcars %>%
    rownames_to_column(var = "USUBJID")

  expected <- tibble::tribble(
    ~vs, ~vs_ord,      ~label,              ~X4,              ~X6,              ~X8,    ~row_type, ~group_level,
    "0",      1L,         "0",               "",               "",               "", "BY_HEADER1",            0,
    "0",      1L,         "N",              "1",              "3",             "14",          "N",            0,
    "0",      1L, "Mean (SD)",      "26.00 (-)",  "20.57 (0.751)",  "15.10 (2.560)",      "VALUE",            0,
    "0",      1L,    "Median",          "26.00",          "21.00",          "15.20",      "VALUE",            0,
    "0",      1L,     "Range",   "(26.0; 26.0)",   "(19.7; 21.0)",   "(10.4; 19.2)",      "VALUE",            0,
    "0",      1L,  "IQ range", "(26.00; 26.00)", "(19.70; 21.00)", "(14.30; 16.40)",      "VALUE",            0,
    "1",      2L,         "1",               "",               "",               "", "BY_HEADER1",            0,
    "1",      2L,         "N",             "10",              "4",              "0",          "N",            0,
    "1",      2L, "Mean (SD)",  "26.73 (4.748)",  "19.13 (1.632)",              "-",      "VALUE",            0,
    "1",      2L,    "Median",          "25.85",          "18.65",              "-",      "VALUE",            0,
    "1",      2L,     "Range",   "(21.4; 33.9)",   "(17.8; 21.4)",         "(-; -)",      "VALUE",            0,
    "1",      2L,  "IQ range", "(22.80; 30.40)", "(17.95; 20.30)",         "(-; -)",      "VALUE",            0
  )

  expect_equal(
    univar(
      mtcars2,
      colvar = "cyl",
      rowvar = "mpg",
      rowbyvar = "vs",
      .ord = TRUE
    ),
    expected,
    ignore_attr = TRUE
  )

  expected <- tibble::tribble(
    ~am, ~vs, ~vs_ord,      ~label, ~am_ord,              ~X4,              ~X6,              ~X8,    ~row_type, ~group_level,
    "0", "0",      1L,         "0",      NA,               "",               "",               "", "BY_HEADER1",            0,
    "0", "0",      1L,         "N",      1L,              "0",              "0",             "12",          "N",            0,
    "0", "0",      1L, "Mean (SD)",      1L,              "-",              "-",  "15.05 (2.774)",      "VALUE",            0,
    "0", "0",      1L,    "Median",      1L,              "-",              "-",          "15.20",      "VALUE",            0,
    "0", "0",      1L,     "Range",      1L,         "(-; -)",         "(-; -)",   "(10.4; 19.2)",      "VALUE",            0,
    "0", "0",      1L,  "IQ range",      1L,         "(-; -)",         "(-; -)", "(13.80; 16.85)",      "VALUE",            0,
    "0", "1",      2L,         "1",      NA,               "",               "",               "", "BY_HEADER1",            0,
    "0", "1",      2L,         "N",      1L,              "3",              "4",              "0",          "N",            0,
    "0", "1",      2L, "Mean (SD)",      1L,  "22.90 (1.453)",  "19.13 (1.632)",              "-",      "VALUE",            0,
    "0", "1",      2L,    "Median",      1L,          "22.80",          "18.65",              "-",      "VALUE",            0,
    "0", "1",      2L,     "Range",      1L,   "(21.5; 24.4)",   "(17.8; 21.4)",         "(-; -)",      "VALUE",            0,
    "0", "1",      2L,  "IQ range",      1L, "(21.50; 24.40)", "(17.95; 20.30)",         "(-; -)",      "VALUE",            0,
    "1", "0",      1L,         "0",      NA,               "",               "",               "", "BY_HEADER1",            0,
    "1", "0",      1L,         "N",      2L,              "1",              "3",              "2",          "N",            0,
    "1", "0",      1L, "Mean (SD)",      2L,      "26.00 (-)",  "20.57 (0.751)",  "15.40 (0.566)",      "VALUE",            0,
    "1", "0",      1L,    "Median",      2L,          "26.00",          "21.00",          "15.40",      "VALUE",            0,
    "1", "0",      1L,     "Range",      2L,   "(26.0; 26.0)",   "(19.7; 21.0)",   "(15.0; 15.8)",      "VALUE",            0,
    "1", "0",      1L,  "IQ range",      2L, "(26.00; 26.00)", "(19.70; 21.00)", "(15.00; 15.80)",      "VALUE",            0,
    "1", "1",      2L,         "1",      NA,               "",               "",               "", "BY_HEADER1",            0,
    "1", "1",      2L,         "N",      2L,              "7",              "0",              "0",          "N",            0,
    "1", "1",      2L, "Mean (SD)",      2L,  "28.37 (4.758)",              "-",              "-",      "VALUE",            0,
    "1", "1",      2L,    "Median",      2L,          "30.40",              "-",              "-",      "VALUE",            0,
    "1", "1",      2L,     "Range",      2L,   "(21.4; 33.9)",         "(-; -)",         "(-; -)",      "VALUE",            0,
    "1", "1",      2L,  "IQ range",      2L, "(22.80; 32.40)",         "(-; -)",         "(-; -)",      "VALUE",            0
  )

  expect_equal(
    univar(
      mtcars2,
      colvar = "cyl",
      rowvar = "mpg",
      rowbyvar = "vs",
      tablebyvar = "am",
      .ord = TRUE
    ),
    expected,
    ignore_attr = TRUE
  )

  expected <- tibble::tribble(
    ~vs, ~vs_ord, ~am, ~am_ord,      ~label,              ~X4,              ~X6,              ~X8,    ~row_type, ~group_level,
    "0",      1L,  "",       0,         "0",               "",               "",               "", "BY_HEADER1",            0,
    "0",      1L, "0",       1,         "0",               "",               "",               "", "BY_HEADER2",            1,
    "0",      1L, "0",       1,         "N",              "0",              "0",             "12",          "N",            1,
    "0",      1L, "0",       1, "Mean (SD)",              "-",              "-",  "15.05 (2.774)",      "VALUE",            1,
    "0",      1L, "0",       1,    "Median",              "-",              "-",          "15.20",      "VALUE",            1,
    "0",      1L, "0",       1,     "Range",         "(-; -)",         "(-; -)",   "(10.4; 19.2)",      "VALUE",            1,
    "0",      1L, "0",       1,  "IQ range",         "(-; -)",         "(-; -)", "(13.80; 16.85)",      "VALUE",            1,
    "0",      1L, "1",       2,         "1",               "",               "",               "", "BY_HEADER2",            1,
    "0",      1L, "1",       2,         "N",              "1",              "3",              "2",          "N",            1,
    "0",      1L, "1",       2, "Mean (SD)",      "26.00 (-)",  "20.57 (0.751)",  "15.40 (0.566)",      "VALUE",            1,
    "0",      1L, "1",       2,    "Median",          "26.00",          "21.00",          "15.40",      "VALUE",            1,
    "0",      1L, "1",       2,     "Range",   "(26.0; 26.0)",   "(19.7; 21.0)",   "(15.0; 15.8)",      "VALUE",            1,
    "0",      1L, "1",       2,  "IQ range", "(26.00; 26.00)", "(19.70; 21.00)", "(15.00; 15.80)",      "VALUE",            1,
    "1",      2L,  "",       0,         "1",               "",               "",               "", "BY_HEADER1",            0,
    "1",      2L, "0",       1,         "0",               "",               "",               "", "BY_HEADER2",            1,
    "1",      2L, "0",       1,         "N",              "3",              "4",              "0",          "N",            1,
    "1",      2L, "0",       1, "Mean (SD)",  "22.90 (1.453)",  "19.13 (1.632)",              "-",      "VALUE",            1,
    "1",      2L, "0",       1,    "Median",          "22.80",          "18.65",              "-",      "VALUE",            1,
    "1",      2L, "0",       1,     "Range",   "(21.5; 24.4)",   "(17.8; 21.4)",         "(-; -)",      "VALUE",            1,
    "1",      2L, "0",       1,  "IQ range", "(21.50; 24.40)", "(17.95; 20.30)",         "(-; -)",      "VALUE",            1,
    "1",      2L, "1",       2,         "1",               "",               "",               "", "BY_HEADER2",            1,
    "1",      2L, "1",       2,         "N",              "7",              "0",              "0",          "N",            1,
    "1",      2L, "1",       2, "Mean (SD)",  "28.37 (4.758)",              "-",              "-",      "VALUE",            1,
    "1",      2L, "1",       2,    "Median",          "30.40",              "-",              "-",      "VALUE",            1,
    "1",      2L, "1",       2,     "Range",   "(21.4; 33.9)",         "(-; -)",         "(-; -)",      "VALUE",            1,
    "1",      2L, "1",       2,  "IQ range", "(22.80; 32.40)",         "(-; -)",         "(-; -)",      "VALUE",            1
  )

  expect_equal(
    univar(
      mtcars2,
      colvar = "cyl",
      rowvar = "mpg",
      rowbyvar = c("vs", "am"),
      .ord = TRUE
    ),
    expected,
    ignore_attr = TRUE
  )
})
