% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blend_waters.R
\name{blend_waters_chain}
\alias{blend_waters_chain}
\title{Apply `blend_waters` within a dataframe and output a column of `water` class to be chained to other tidywater functions}
\usage{
blend_waters_chain(df, waters, ratios, output_water = "blended_water")
}
\arguments{
\item{df}{a data frame containing a water class column, which has already
been computed using \code{\link{define_water_chain}},}

\item{waters}{List of column names containing a water class to be blended}

\item{ratios}{List of column names or vector of blend ratios in the same order as waters. (Blend ratios must sum to 1)}

\item{output_water}{name of output column storing updated parameters with the class, water. Default is "blended_water".}
}
\value{
A data frame with a water class column containing updated ions and pH.
}
\description{
This function allows \code{\link{blend_waters}} to be added to a piped data frame.
}
\details{
The data input comes from a `water` class column, initialized in \code{\link{define_water}} or \code{\link{balance_ions}}.
The `water` class columns to use in the function are specified as function arguments. Ratios may be input
as columns with varied ratios (in this case, input column names in the function arguments), OR input as numbers directly.

 For large datasets, using `fn_once` or `fn_chain` may take many minutes to run. These types of functions use the furrr package
 for the option to use parallel processing and speed things up. To initialize parallel processing, use
 `plan(multisession)` or `plan(multicore)` (depending on your operating system) prior to your piped code with the
 `fn_once` or `fn_chain` functions. Note, parallel processing is best used when your code block takes more than a minute to run,
 shorter run times will not benefit from parallel processing.
}
\examples{

library(purrr)
library(furrr)
library(tidyr)
library(dplyr)

example_df <- water_df \%>\%
  define_water_chain() \%>\%
  balance_ions_chain() \%>\%
  chemdose_ph_chain(naoh = 22) \%>\%
  mutate(
    ratios1 = .4,
    ratios2 = .6
  ) \%>\%
  blend_waters_chain(
    waters = c("defined_water", "dosed_chem_water"),
    ratios = c("ratios1", "ratios2"), output_water = "Blending_after_chemicals"
  )


example_df <- water_df \%>\%
  define_water_chain() \%>\%
  balance_ions_chain() \%>\%
  chemdose_ph_chain(naoh = 22, output_water = "dosed") \%>\%
  blend_waters_chain(waters = c("defined_water", "dosed", "balanced_water"), ratios = c(.2, .3, .5))

\donttest{
# Initialize parallel processing
plan(multisession, workers = 2) # Remove the workers argument to use all available compute
example_df <- water_df \%>\%
  define_water_chain() \%>\%
  balance_ions_chain() \%>\%
  chemdose_ph_chain(naoh = 22, output_water = "dosed") \%>\%
  blend_waters_chain(waters = c("defined_water", "dosed", "balanced_water"), ratios = c(.2, .3, .5))

# Optional: explicitly close multisession processing
plan(sequential)
}

}
\seealso{
\code{\link{blend_waters}}
}
