% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemdose_f.R
\name{chemdose_f}
\alias{chemdose_f}
\title{Calculate new fluoride concentration after dosing alum.}
\usage{
chemdose_f(water, alum, coeff = c(1.11, 0.628, -2.07, 0.861))
}
\arguments{
\item{water}{Source water object of class "water" created by \code{\link{define_water}}}

\item{alum}{Amount of hydrated aluminum sulfate added in mg/L: Al2(SO4)3*14H2O + 6HCO3 -> 2Al(OH)3(am) +3SO4 + 14H2O + 6CO2}

\item{coeff}{Model coefficients to use as vector of numbers.}
}
\value{
A water class object with an updated fluoride concentration.
}
\description{
Applies equation of the form: raw_f - A*alum^a*ph ^ b * raw_f^c. There is no published model, so it is
recommended to fit the coefficients with experimental data. When fitting, the following units must be used:
Alum in mg/L as chemical, Fluoride in mg/L, pH in SU. Default coefficients are fit from Sollo et al (1978). This function
outputs a water class object with an updated fluoride concentration (which will be in M, per standard water units).
}
\examples{
dosed_water <- define_water(ph = 7, temp = 25, alk = 50, f = 4) \%>\%
  chemdose_ph(alum = 50) \%>\%
  chemdose_f(alum = 50)

convert_units(dosed_water@f, "f", "M", "mg/L")

}
