% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_pluck_water.R
\name{convert_watermg}
\alias{convert_watermg}
\title{Convert a `water` class object to a dataframe with ions in mg/L or ug/L}
\usage{
convert_watermg(water)
}
\arguments{
\item{water}{A water class object}
}
\value{
A data frame containing columns for all non-NA water slots with ions in mg/L.
}
\description{
This function is the same as \code{\link{convert_water}} except it converts the units of following slots from
M to mg/L: na, ca, mg, k, cl, so4, hco3, co3, h2po4, hpo4, po4, ocl, bro3, f, fe, al.  These slots are converted to
ug/L: br, mn.  All other values remain unchanged.
}
\examples{
water_defined <- define_water(7, 20, 50, 100, 80, 10, 10, 10, 10, tot_po4 = 1) \%>\%
  convert_watermg()

}
