% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dissolve_pb.R
\name{dissolve_pb}
\alias{dissolve_pb}
\title{Simulate contributions of various lead solids to total soluble lead}
\source{
Code is from EPA's TELSS lead solubility dashboard \url{https://github.com/USEPA/TELSS}
which is licensed under MIT License:
Permission is hereby granted, free of charge, to any person obtaining a copy of this software and
associated documentation files (the "Software"), to deal in the Software without restriction,
including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the
following conditions: The above copyright notice and this permission notice shall be included in all copies or
substantial portions of the Software.

Wahman et al. (2021)

See references list at: \url{https://github.com/BrownandCaldwell-Public/tidywater/wiki/References}
}
\usage{
dissolve_pb(
  water,
  hydroxypyromorphite = "Schock",
  pyromorphite = "Topolska",
  laurionite = "Nasanen"
)
}
\arguments{
\item{water}{Source water object of class "water" created by \code{\link{define_water}}. Water must include alk and is.
If po4, cl, and so4 are known, those should also be included.}

\item{hydroxypyromorphite}{defaults to "Schock", the constant, K, developed by Schock et al (1996). Can also use "Zhu".}

\item{pyromorphite}{defaults to "Topolska", the constant, K, developed by Topolska et al (2016). Can also use "Xie".}

\item{laurionite}{defaults to "Nasanen", the constant, K, developed by Nasanen & Lindell (1976). Can also use "Lothenbach".}
}
\value{
A data frame containing only the controlling lead solid and modeled dissolved lead concentration.
}
\description{
This function takes a water data frame defined by \code{\link{define_water}}
and outputs a dataframe of the controlling lead solid and total lead solubility.
Lead solid solubility is calculated based on controlling solid.
Total dissolved lead species (tot_dissolved_pb, M) are calculated based on lead complex calculations.
Some lead solids have two k-constant options. The function will default to the EPA's default constants.
The user may change the constants to hydroxypyromorphite = "Zhu" or pyromorphite = "Xie" or laurionite = "Lothenbach"
}
\details{
The solid with lowest solubility will form the lead scale (controlling lead solid).

Make sure that total dissolved solids, conductivity, or
ca, na, cl, so4 are used in `define_water` so that an ionic strength is calculated.
}
\examples{

example_pb <- define_water(
  ph = 7.5, temp = 25, alk = 93, cl = 240,
  tot_po4 = 0, so4 = 150, tds = 200
) \%>\%
  dissolve_pb()
example_pb <- define_water(
  ph = 7.5, temp = 25, alk = 93, cl = 240,
  tot_po4 = 0, so4 = 150, tds = 200
) \%>\%
  dissolve_pb(pyromorphite = "Xie")

}
\seealso{
\code{\link{define_water}}
}
