% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidywater-package.R
\docType{data}
\name{dbpcoeffs}
\alias{dbpcoeffs}
\title{Data frame of DBP coefficients for predicting DBP formation}
\format{
A dataframe with 30 rows and 10 columns
\describe{
\item{ID}{abbreviation of dbp species}
\item{alias}{full name of dbp species}
\item{water_type}{specifies which model the constants apply to, either treated or untreated water}
\item{A}{First coefficient in DBP model}
\item{a}{Second coefficient in DBP model, associated with TOC or DOC}
\item{b}{Third coefficient in DBP model, associated with Cl2 }
\item{c}{Fourth coefficient in DBP model, associated with Br-}
\item{d}{Fifth coefficient in DBP model, associated with temperature}
\item{e}{Sixth coefficient in DBP model, associated with pH}
\item{f}{Seventh coefficient in DBP model, associated with reaction time}
}
}
\source{
U.S. EPA (2001)

See references list at: \url{https://github.com/BrownandCaldwell-Public/tidywater/wiki/References}
}
\usage{
dbpcoeffs
}
\description{
A dataset containing coefficients for calculating DBP formation
}
\keyword{datasets}
