% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tw_get_cached_search.R
\name{tw_get_cached_search}
\alias{tw_get_cached_search}
\title{Retrieve cached search}
\usage{
tw_get_cached_search(
  search,
  type = "item",
  language = tidywikidatar::tw_get_language(),
  cache = NULL,
  include_search = FALSE,
  cache_connection = NULL,
  disconnect_db = TRUE
)
}
\arguments{
\item{search}{A string to be searched in Wikidata}

\item{type}{Defaults to "item". Either "item" or "property".}

\item{language}{Defaults to language set with \code{tw_set_language()}; if not set, "en". Use "all_available" to keep all languages. For available language values, see https://www.wikidata.org/wiki/Help:Wikimedia_language_codes/lists/all}

\item{cache}{Defaults to NULL. If given, it should be given either TRUE or FALSE. Typically set with \code{tw_enable_cache()} or \code{tw_disable_cache()}.}

\item{include_search}{Logical, defaults to FALSE. If TRUE, the search is returned as an additional column.}

\item{cache_connection}{Defaults to NULL. If NULL, and caching is enabled, \code{tidywikidatar} will use a local sqlite database. A custom connection to other databases can be given (see vignette \code{caching} for details).}

\item{disconnect_db}{Defaults to TRUE. If FALSE, leaves the connection to cache open.}
}
\value{
If data present in cache, returns a data frame with cached data.
}
\description{
Retrieve cached search
}
\examples{


tw_set_cache_folder(path = tempdir())
tw_enable_cache()
tw_create_cache_folder(ask = FALSE)

search_from_api <- tw_search("Sylvia Pankhurst")
search_from_api

df_from_cache <- tw_get_cached_search("Sylvia Pankhurst")
df_from_cache
}
