% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tw_filter.R
\name{tw_filter_people}
\alias{tw_filter_people}
\title{Filter search result and keep only people}
\usage{
tw_filter_people(
  search,
  language = tidywikidatar::tw_get_language(),
  response_language = tidywikidatar::tw_get_language(),
  limit = 10,
  include_search = FALSE,
  stop_at_first = TRUE,
  wait = 0,
  overwrite_cache = FALSE,
  cache_connection = NULL,
  disconnect_db = TRUE
)
}
\arguments{
\item{search}{A data frame generated by \code{tw_search()}, or a search query. If
a data frame is given, language and limits are ignore.}

\item{language}{Language to be used for the search. Can be set once per
session with \code{\link[=tw_set_language]{tw_set_language()}}. If not set, defaults to "en". For a full
list, see
\href{https://www.wikidata.org/wiki/Help:Wikimedia_language_codes/lists/all}{the
dedicated Wikimedia page}.}

\item{response_language}{Language to be used for the returned labels and
descriptions. Corresponds to the \code{uselang} parameter of the MediaWiki API,
as described
\href{https://www.wikidata.org/w/api.php?action=help&modules=wbsearchentities}{in
the official documentation}. Can be set once per session with
\code{\link[=tw_set_language]{tw_set_language()}}. If not set, defaults to "en". For a full list, see
\href{https://www.wikidata.org/wiki/Help:Wikimedia_language_codes/lists/all}{all
available language codes}.}

\item{limit}{Maximum numbers of responses to be given.}

\item{include_search}{Logical, defaults to \code{FALSE}. If \code{TRUE}, the search is
returned as an additional column.}

\item{stop_at_first}{Logical, defaults to TRUE. If TRUE, returns only the
first match from the search that satisfies the criteria.}

\item{wait}{In seconds, defaults to 0. Time to wait between queries to
Wikidata. If data are cached locally, wait time is not applied. If you are
running many queries systematically you may want to add some waiting time
between queries.}

\item{overwrite_cache}{Defaults to \code{FALSE}. If \code{TRUE}, overwrites cache.}

\item{cache_connection}{Defaults to \code{NULL}. If \code{NULL}, and caching is
enabled, \code{tidywikidatar} will use a local sqlite database. A custom
connection to other databases can be given (see vignette \code{caching} for
details).}

\item{disconnect_db}{Defaults to \code{TRUE}. If \code{FALSE}, leaves the connection to
cache open.}
}
\value{
A data frame with three columns, \code{id}, \code{label}, and \code{description};
all rows refer to a human being.
}
\description{
A wrapper of \code{\link[=tw_filter]{tw_filter()}} that defaults to keep only "instance of" (P31)
"human being" (Q5).
}
\examples{
tw_search("Ruth Benedict")

tw_search("Ruth Benedict") \%>\%
  tw_filter_people()
}
