% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{sample_db}
\alias{sample_db}
\title{Example human Rep-Seq data}
\format{A \code{data.frame} where rows correspond to unique VDJ sequences and
columns include:
\itemize{
  \item IMGT-gapped nucleotide sequence (\code{"SEQUENCE_IMGT"})
  \item IMGT/V-QUEST allele calls (\code{"V_CALL"}, \code{"D_CALL"}, and
    \code{"J_CALL"})
  \item Junction length (\code{"JUNCTION_LENGTH"})
}}
\description{
Example VDJ-rearranged immunoglobulin Rep-Seq sequences derived from a single
individual (PGP1), sequenced on the Roche 454 platform, and thought by
IMGT/V-QUEST to utilize IGHV1 family alleles.
}
\references{
Gadala-Maria \emph{et al}. (2015) Automated analysis of
high-throughput B cell sequencing data reveals a high frequency of novel
immunoglobulin V gene segment alleles. \emph{PNAS}. 112(8):E862-70.
}
\keyword{data}

