% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enumeration_units.R
\name{block_groups}
\alias{block_groups}
\title{Download a Census block groups shapefile into R, and optionally subset by county}
\usage{
block_groups(state, county = NULL, cb = FALSE, year = NULL, ...)
}
\arguments{
\item{state}{The two-digit FIPS code (string) of the state you want. Can also
be state name or state abbreviation.}

\item{county}{The three-digit FIPS code (string) of the county you'd like to
subset for, or a vector of FIPS codes if you desire multiple counties.
Can also be a county name or vector of names.}

\item{cb}{If cb is set to TRUE, download a generalized (1:500k)
file.  Defaults to FALSE (the most detailed TIGER/Line file)}

\item{year}{the data download year (defaults to 2015)}

\item{...}{arguments to be passed to the underlying `load_tiger` function, which is not exported.
Options include \code{refresh}, which specifies whether or not to re-download shapefiles
(defaults to \code{FALSE}).}
}
\description{
Description from the US Census Bureau (see link for source):Standard block groups are clusters of
blocks within the same census tract that have the same first digit of
their 4-character census block number. For example, blocks 3001, 3002, 3003..., 3999 in census tract
1210.02 belong to Block Group 3. Due to boundary and feature changes that occur throughout the
decade, current block groups do not always maintain these same block number to block group
relationships. For example, block 3001 might move due to a census tract boundary change but the block
number will not change, even if it does not still fall in block group 3. However, the GEOID for that block,
identifying block group 3, would remain the same in the attribute information in the TIGER/Line Shapefiles
because block GEOIDs are always built using the decennial geographic codes.
}
\details{
Block groups delineated for the 2010 Census generally contain between 600 and 3,000 people. Most
block groups were delineated by local participants in the Census Bureau's Participant Statistical Areas
Program (PSAP). The Census Bureau delineated block groups only where a local or tribal government
declined to participate or where the Census Bureau could not identify a potential local participant.

A block group usually covers a contiguous area. Each census tract contains at least one block group and
block groups are uniquely numbered within census tract. Within the standard census geographic
hierarchy, block groups never cross county or census tract boundaries, but may cross the boundaries of
county subdivisions, places, urban areas, voting districts, congressional districts, and American Indian,
Alaska Native, and Native Hawaiian areas.
}
\examples{
\dontrun{
library(tigris)

benton_bgs <- block_groups("Oregon", "Benton")

plot(benton_bgs)
}
}
\seealso{
\url{http://www2.census.gov/geo/pdfs/maps-data/data/tiger/tgrshp2015/TGRSHP2015_TechDoc.pdf}

Other general area functions: \code{\link{blocks}},
  \code{\link{counties}},
  \code{\link{county_subdivisions}}, \code{\link{places}},
  \code{\link{pumas}}, \code{\link{school_districts}},
  \code{\link{states}}, \code{\link{tracts}},
  \code{\link{zctas}}
}
