% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legislative.R
\name{congressional_districts}
\alias{congressional_districts}
\title{Download a congressional districts shapefile for the 114th Congress into R}
\usage{
congressional_districts(cb = FALSE, resolution = "500k", year = NULL, ...)
}
\arguments{
\item{cb}{If cb is set to TRUE, download a generalized (1:500k)
cartographic boundary file.  Defaults to FALSE (the most detailed
TIGER/Line file).}

\item{resolution}{The resolution of the cartographic boundary file (if cb == TRUE).
Defaults to '500k'; options include '5m' (1:5 million) and '20m' (1:20 million).}

\item{year}{the data year (defaults to 2015).}

\item{...}{arguments to be passed to the underlying `load_tiger` function, which is not exported.
Options include \code{refresh}, which specifies whether or not to re-download shapefiles
(defaults to \code{FALSE}).}
}
\description{
Description from the US Census Bureau (see link for source):
The 2015 TIGER/Line Shapefiles contain the 114th Congressional Districts. All congressional districts
appearing in the 2015 TIGER/Line Shapefiles reflect the information provided to the Census Bureau by
the states by May 1, 2014. The 114th Congressional District shapefile contains the areas in effect
January 2015 to 2017.
}
\details{
Congressional districts are the 435 areas from which people are elected to the U.S. House of
Representatives and the five areas with nonvoting delegates from state equivalents. After the
apportionment of congressional seats among the states based on decennial census population counts,
each state is responsible for establishing the boundaries of the congressional districts for the purpose of
electing representatives. Each congressional district is to be as equal in population to all other
congressional districts in a state as practicable.
}
\examples{
\dontrun{
library(tigris)
library(leaflet)

cd114 <- congressional_districts(cb = TRUE, resolution = '20m')

leaflet(cd114) \%>\%
   addTiles() \%>\%
   addPolygons()
}
}
\seealso{
\url{http://www2.census.gov/geo/pdfs/maps-data/data/tiger/tgrshp2015/TGRSHP2015_TechDoc.pdf}

Other legislative district functions: \code{\link{state_legislative_districts}},
  \code{\link{voting_districts}}
}
