% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transportation.R
\name{rails}
\alias{rails}
\title{Download a national rails shapefile into R}
\usage{
rails(year = NULL, ...)
}
\arguments{
\item{year}{the data year (defaults to 2019).}

\item{...}{arguments to be passed to the underlying `load_tiger` function, which is not exported.
Options include \code{class}, which can be set to \code{"sf"} (the default) or \code{"sp"} to
request sf or sp class objects, and \code{refresh}, which specifies whether or
not to re-download shapefiles (defaults to \code{FALSE}).}
}
\description{
National dataset for US railroads, including carlines, streetcars,
monorails, mass transit, cog rail, incline rail, and trams.
}
\examples{
\dontrun{
library(tigris)

rls <- rails()

plot(rls$geometry)

}
}
\seealso{
\url{https://www2.census.gov/geo/pdfs/maps-data/data/tiger/tgrshp2019/TGRSHP2019_TechDoc.pdf}

Other transportation functions: 
\code{\link{address_ranges}()},
\code{\link{primary_roads}()},
\code{\link{primary_secondary_roads}()},
\code{\link{roads}()}
}
\concept{transportation functions}
