% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legislative.R
\name{state_legislative_districts}
\alias{state_legislative_districts}
\title{Download a state legislative districts shapefile into R - upper or lower}
\usage{
state_legislative_districts(
  state = NULL,
  house = "upper",
  cb = FALSE,
  year = NULL,
  ...
)
}
\arguments{
\item{state}{The two-digit FIPS code (string) of the state. Can also be state
name or abbreviation (case-insensitive). When \code{NULL} and combined with
\code{cb = TRUE}, a national dataset of state legislative districts will be returned.}

\item{house}{Specify here whether you want boundaries for the \code{upper} or
\code{lower} house.  Defaults to \code{upper}.}

\item{cb}{If cb is set to TRUE, download a generalized (1:500k)
cartographic boundary file.  Defaults to FALSE (the most detailed
TIGER/Line file).}

\item{year}{the data year; defaults to 2021}

\item{...}{arguments to be passed to internal function \code{load_tiger}, which is not exported. See Additional Arguments.}
}
\description{
This function allows you to download boundaries for state legislatures into R.
Generally, state legislatures are comprised of an "upper" house, which is
typically referred to as the Senate, and a "lower" house, which is often (but
not exclusively) referred to as the House.  The exception is Nebraska, which
has a unicameral state legislature.
}
\section{Additional Arguments}{

Additional arguments that can be passed in \code{...} are:
\itemize{
\item \code{class} Desired class of return object: \code{"sf"} (the default) or \code{"sp"}.  sp classes should be considered deprecated as of tigris version 2.0, but legacy support is still available.
\item \code{progress_bar} If set to \code{FALSE}, do not display download progress bar (helpful for R Markdown documents). Defaults to \code{TRUE}.
\item \code{keep_zipped_shapefile} If set to \code{TRUE}, do not delete zipped shapefile (stored in temporary directory or \code{TIGRIS_CACHE_DIR}
depending on the configuration of global option \code{"tigris_use_cache"}). Defaults to \code{FALSE}.
\item \code{refresh} Whether to re-download cached shapefiles (\code{TRUE} or \code{FALSE}) . The default is either \code{FALSE} or the value of global
option \code{"tigris_refresh"} if it is set. Specifying this argument will override the behavior set in \code{"tigris_refresh"} global option.
\item \code{filter_by} Geometry used to filter the output returned by the function.  Can be an sf object, an object of class \code{bbox}, or a length-4 vector of format \code{c(xmin, ymin, xmax, ymax)} that can be converted to a bbox. Geometries that intersect the input to \code{filter_by} will be returned.
}
}

\examples{
\dontrun{
library(tigris)
library(leaflet)

leg <- state_legislative_districts("Maine", "lower", cb = TRUE)

leaflet(leg) \%>\%
  addProviderTiles("CartoDB.Positron") \%>\%
  addPolygons(fillColor = "white",
              color = "black",
              weight = 0.5)
}
}
\seealso{
\url{https://www.census.gov/programs-surveys/geography/guidance/geo-areas/state-legis-dist.html}

Other legislative district functions: 
\code{\link{congressional_districts}()},
\code{\link{voting_districts}()}
}
\concept{legislative district functions}
