% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viz.R
\name{plot_heatmap}
\alias{plot_heatmap}
\title{Heatmap of parameters vs. sites}
\usage{
plot_heatmap(df_long)
}
\arguments{
\item{df_long}{Long-format data frame with columns \code{data}, \code{parametro}, \code{valor}.}
}
\value{
A \code{ggplot} object.
}
\description{
Heatmap for long-format data (date x parameter).
}
\examples{
\donttest{
# Example: reshape wq_demo to long and plot
data(wq_demo)
library(tidyr)
df_long <- tidyr::pivot_longer(
  wq_demo,
  cols = c("ph","od","turbidez","dbo"),
  names_to = "parametro",
  values_to = "valor"
)
plot_heatmap(df_long)
}

}
