% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/num_na.R
\name{num_na}
\alias{num_na}
\title{Fast number of missing values}
\usage{
num_na(x)
}
\arguments{
\item{x}{A vector.}
}
\value{
Number of \code{NA} values.
}
\description{
A faster and more efficient alternative to \code{sum(is.na(x))}. \cr
Long vectors, i.e vectors with length >= 2^31 are also supported.
}
\examples{
library(timeplyr)
library(bench)
\dontshow{
.n_dt_threads <- data.table::getDTthreads()
.n_collapse_threads <- collapse::get_collapse()$nthreads
data.table::setDTthreads(threads = 2L)
collapse::set_collapse(nthreads = 1L)
}
flights <- nycflights13::flights

# num_na is more efficient than using `sum(is.na())`
mark(vapply(flights, num_na, integer(1)),
     vapply(flights, function(x) sum(is.na(x)), integer(1)),
     iterations = 10)
\dontshow{
data.table::setDTthreads(threads = .n_dt_threads)
collapse::set_collapse(nthreads = .n_collapse_threads)
}
}
