% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recurrent.r
\name{recurrent.marginal.coxmean}
\alias{recurrent.marginal.coxmean}
\title{Estimates marginal mean of recurrent events  based on two cox models}
\usage{
recurrent.marginal.coxmean(recurrent, death)
}
\arguments{
\item{recurrent}{aalen model for recurrent events}

\item{death}{cox.aalen (cox) model for death events}
}
\description{
Fitting two aalen models for death and recurent events these are
combined to prducte the estimator 
\deqn{ \int_0^t  S(u|x=0) dR(u|x=0) } the mean number of recurrent events, here
\deqn{ S(u|x=0) }  is the probability of survival, and 
\deqn{ dR(u|x=0) }  is the probability of an event among survivors. 
For now the estimator is based on the two-baselines so \deqn{x=0}, but covariates
can be rescaled to look at different x's and extensions possible.
}
\details{
IID versions along the lines of Ghosh & Lin (2000) variance. See also mets package for 
quick version of this for large data. 
IID versions used for Ghosh & Lin (2000) variance. See also mets package for 
quick version of this for large data mets:::recurrent.marginal, these two 
version should give the same when there are now ties.
}
\examples{
\donttest{
### do not test because iid slow  and uses data from mets
require(mets)
data(simrecurrent)
dim(simd) 
simd <- subset(simd,id<500)

ar <- cox.aalen(Surv(start,stop,status)~+1+prop(x.V1)+cluster(id),data=simd,
                   resample.iid=1,,max.clust=NULL,max.timepoint.sim=NULL)

ad <- cox.aalen(Surv(start,stop,death)~+1+prop(x.V1)+cluster(id),data=simd,
                   resample.iid=1,,max.clust=NULL,max.timepoint.sim=NULL)
mm <- recurrent.marginal.coxmean(ar,ad)
with(mm,plot(times,mu,type="s"))
with(mm,lines(times,mu+1.96*se.mu,type="s",lty=2))
with(mm,lines(times,mu-1.96*se.mu,type="s",lty=2))
}
}
\references{
Ghosh and Lin (2002) Nonparametric Analysis of Recurrent events and death, 
                     Biometrics, 554--562.
}
\author{
Thomas Scheike
}
\keyword{survival}
