% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-tk_get_time_scale_template.R
\name{set_tk_time_scale_template}
\alias{set_tk_time_scale_template}
\alias{get_tk_time_scale_template}
\alias{tk_time_scale_template}
\title{Get and modify the Time Scale Template}
\usage{
set_tk_time_scale_template(.data)

get_tk_time_scale_template()

tk_time_scale_template()
}
\arguments{
\item{.data}{A \code{tibble} with a "time_scale", "frequency", and "trend" columns.}
}
\description{
Get and modify the Time Scale Template
}
\details{
Used to get and set the time scale template, which is used by \code{tk_get_frequency()}
and \code{tk_get_trend()} when \code{period = "auto"}.

The predefined template is stored in a function \code{tk_time_scale_template()}.
This is the default used by \code{timetk}.

\strong{Changing the Default Template}
\itemize{
\item You can access the current template with \code{get_tk_time_scale_template()}.
\item You can modify the current template with \code{set_tk_time_scale_template()}.
}
}
\examples{

get_tk_time_scale_template()

set_tk_time_scale_template(tk_time_scale_template())

}
\seealso{
\itemize{
\item Automated Frequency and Trend Calculation: \code{\link[=tk_get_frequency]{tk_get_frequency()}}, \code{\link[=tk_get_trend]{tk_get_trend()}}
}
}
