% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vec-ts_clean.R
\name{ts_clean_vec}
\alias{ts_clean_vec}
\title{Replace Outliers & Missing Values in a Time Series}
\usage{
ts_clean_vec(x, period = 1, lambda = NULL)
}
\arguments{
\item{x}{A numeric vector.}

\item{period}{A seasonal period to use during the transformation. If \code{period = 1},
seasonality is not included and \code{supsmu()} is used to fit a trend.
If \code{period > 1}, a robust STL decomposition is
first performed and a linear interpolation is applied to the seasonally adjusted data.}

\item{lambda}{A box cox transformation parameter. If set to \code{"auto"}, performs
automated lambda selection.}
}
\value{
A \code{numeric} vector with the missing values and/or anomalies transformed to imputed values.
}
\description{
This is mainly a wrapper for the outlier cleaning function,
\code{tsclean()}, from the \code{forecast} R package.
The \code{ts_clean_vec()} function includes arguments for applying
seasonality to numeric vector (non-\code{ts}) via the \code{period} argument.
}
\details{
\strong{Cleaning Outliers}
\enumerate{
\item Non-Seasonal (\code{period = 1}): Uses \code{stats::supsmu()}
\item Seasonal (\code{period > 1}): Uses \code{forecast::mstl()} with \code{robust = TRUE} (robust STL decomposition)
for seasonal series.
}

To estimate missing values and outlier replacements, linear interpolation is used on the
(possibly seasonally adjusted) series. See \code{forecast::tsoutliers()} for the outlier detection method.

\strong{Box Cox Transformation}

In many circumstances, a Box Cox transformation can help. Especially if the series is multiplicative
meaning the variance grows exponentially. A Box Cox transformation can be automated by setting \code{lambda = "auto"}
or can be specified by setting \verb{lambda = numeric value}.
}
\examples{
library(dplyr)
library(timetk)


# --- VECTOR ----

values <- c(1,2,3, 4*2, 5,6,7, NA, 9,10,11, 12*2)
values

# Linear interpolation + Outlier Cleansing
ts_clean_vec(values, period = 1, lambda = NULL)

# Seasonal Interpolation: set period = 4
ts_clean_vec(values, period = 4, lambda = NULL)

# Seasonal Interpolation with Box Cox Transformation (internal)
ts_clean_vec(values, period = 4, lambda = "auto")


}
\references{
\itemize{
\item \href{https://github.com/robjhyndman/forecast}{Forecast R Package}
\item \href{https://otexts.com/fpp2/missing-outliers.html}{Forecasting Principles & Practices: Dealing with missing values and outliers}
}
}
\seealso{
\itemize{
\item Box Cox Transformation: \code{\link[=box_cox_vec]{box_cox_vec()}}
\item Lag Transformation: \code{\link[=lag_vec]{lag_vec()}}
\item Differencing Transformation: \code{\link[=diff_vec]{diff_vec()}}
\item Rolling Window Transformation: \code{\link[=slidify_vec]{slidify_vec()}}
\item Loess Smoothing Transformation: \code{\link[=smooth_vec]{smooth_vec()}}
\item Fourier Series: \code{\link[=fourier_vec]{fourier_vec()}}
\item Missing Value Imputation for Time Series: \code{\link[=ts_impute_vec]{ts_impute_vec()}}
\item Outlier Cleaning for Time Series: \code{\link[=ts_clean_vec]{ts_clean_vec()}}
}
}
