      SUBROUTINE OPTDESF(IR,L,NS,M,Q1,R,GR1,A,B,GI)
C
      INCLUDE 'timsac_f.h'
C
cc      PROGRAM OPTDES
C     PROGRAM 5.5.1   OPTIMAL CONTROLLER DESIGN
C-----------------------------------------------------------------------
C     ** DESIGNED BY H. AKAIKE, THE INSTITUTE OF STATISTICAL MATHEMATICS
C     ** PROGRAMMED BY E. ARAHATA, THE INSTITUTE OF STATISTICAL MATHEMAT
C         TOKYO
C     ** DATE OF THE LATEST REVISION: MARCH 25, 1977
C     ** THIS PROGRAM WAS ORIGINALLY PUBLISHED IN
C         "DAINAMIKKU SISTEMU NO TOKEI-TEKI KAISEKI TO SEIGYO (STATISTICA
C         ANALYSIS AND CONTROL OF DYNAMIC SYSTEMS)" BY H. AKAIKE AND
C         T. NAKAGAWA, SAIENSU-SHA, TOKYO, 1972 (IN JAPANESE)
C-----------------------------------------------------------------------
C     THIS PROGRAM COMPUTES OPTIMAL CONTROLLER GAIN MATRIX FOR
C     A QUADRATIC CRITERION DEFINED BY TWO POSITIVE DEFINITE MATRICES
C     Q1 AND R.
C     THE OUTPUT OF FPEC COMPUTATION IS USED.
C     THE FIRST IR VARIABLES SHOULD BE CONTROLLED VARIABLES.
C     IR: NUMBER OF CONTROLLED VARIABLES
C     L: NUMBER OF MANIPULATED VARIABLES
C     NS: NUMBER OF D.P. STAGES
C     N: LENGTH OF ORIGINAL DATA
C     M: ORDER OF THE MODEL WHICH GIVES THE MINIMUM OF FPEC
C     MATRIX P: MI OR P
C     GI: GAIN
C
cc      !DEC$ ATTRIBUTES DLLEXPORT :: OPTDESF
cc      USE DFLIB
C
cxx      IMPLICIT REAL*8(A-H,O-Z)
cc      DIMENSION A(75,5),B(75,5),Q1(5,5),R(5,5)
cc      DIMENSION GI(5,75),GIT(75,5)
cc      DIMENSION GL(5,5),G3(5,75),GR(5,5),GLR(5,5)
cc      DIMENSION P(75,75),D(75)
cxx      DIMENSION A(M*IR,IR),B(M*IR,L),Q1(IR,IR),R(L,L)
cxx      DIMENSION GI(L,M*IR),GIT(M*IR,IR)
cxx      DIMENSION GL(L,L),G3(L,M*IR),GR(IR,IR),GLR(L,IR)
cxx      DIMENSION P(M*IR,M*IR),D(M*IR)
cxx      DIMENSION GR1(IR,IR)
      INTEGER :: IR, L, NS, M
      REAL(8) :: Q1(IR,IR), R(L,L), GR1(IR,IR), A(M*IR,IR), B(M*IR,L),
     1           GI(L,M*IR)
      REAL(8) :: GIT(M*IR,IR), GL(L,L), G3(L,M*IR), GR(IR,IR),
     1           GLR(L,IR), P(M*IR,M*IR), D(M*IR), XDET, CST0
C     INPUT / OUTPUT DATA FILE OPEN
cc      CHARACTER(100) DFNAM
cc      DFNAM='optdes.out'
cc      CALL SETWND
cc      CALL FLOPN3(DFNAM,NFL)
cc      IF (NFL.EQ.0) GO TO 999
C     ABSOLUTE DIMENSIONS USED FOR SUBROUTINE CALL
cc      MJ1=5
cc      MJ2=5
cc      MJ3=75
      CST0=0.0D-00
C     INITIAL CONDITION INPUT AND OUTPUT
cc      READ(5,1) IR,L,NS
cc      CALL REMTSB(Q1,IR,1,MJ1)
cc      CALL REMTSB(R,L,1,MJ2)
C     READING THE OUTPUTS OF PROGRAM 5.3.2 FPEC
cc      READ(5,1) N,M
cc      CALL REMATX(GR,IR,IR,1,MJ1,MJ1)
cxx      DO 5 I=1,IR
      DO 6 I=1,IR
         DO 5 J=1,IR
            GR(I,J)=GR1(I,J)
    5 CONTINUE
    6 CONTINUE
C     ABOVE INPUT IS NONEFFECTIVE.
cc      IM=0
cc      DO 8 JJ=1,M
cc      DO 9 I=1,IR
cc      II=IM+I
cc    9 READ(5,2) (A(II,J),J=1,IR),(B(II,J),J=1,L)
cc    8 IM=IM+IR
      MR=M*IR
cc      WRITE(6,60)
cc      WRITE(6,61)
cc      WRITE(6,362) N,M
cc      WRITE(6,62) IR,L,NS
cc      WRITE(6,65)
cc      CALL SUBMPR(Q1,IR,IR,MJ1,MJ1)
cc      WRITE(6,66)
cc      CALL SUBMPR(R,L,L,MJ2,MJ2)
cc      WRITE(6,63)
cc      CALL SUBMPR(A,MR,IR,MJ3,MJ1)
cc      WRITE(6,64)
cc      CALL SUBMPR(B,MR,L,MJ3,MJ2)
C     CONSTANTS FOR COMPUTATION
      MR1=MR-IR
      MM1=M-1
      MM2=M-2
      IBA=MM2*IR
C     INITIAL P COMPUTATION
cxx      DO 130 I=1,MR
      DO 132 I=1,MR
      DO 130 J=1,MR
cxx  130 P(I,J)=CST0
      P(I,J)=CST0
  130 CONTINUE
  132 CONTINUE
cxx      DO 131 I=1,IR
      DO 133 I=1,IR
      DO 131 J=1,IR
cxx  131 P(I,J)=Q1(I,J)
      P(I,J)=Q1(I,J)
  131 CONTINUE
  133 CONTINUE
C
C     P ITERATION INS=1 TO NS
      DO 10 INS=1,NS
C     GI=(TRANSPOSE OF B)*P COMPUTATION
cc      CALL TRAMDL(B,P,GI,MR,L,MR,MJ3,MJ2,MJ3)
      CALL TRAMDL(B,P,GI,MR,L,MR)
C     GL=GI*B COMPUTATION
cc      CALL MULTRB(GI,B,GL,L,MR,MJ2,MJ3)
      CALL MULTRB(GI,B,GL,L,MR)
cxx      DO 20 I=1,L
      DO 21 I=1,L
      DO 20 J=1,I
cxx   20 GL(J,I)=GL(I,J)
      GL(J,I)=GL(I,J)
   20 CONTINUE
   21 CONTINUE
C     GL=GL+R COMPUTATION
cc      CALL MATADL(GL,R,L,L,MJ2,MJ2)
      CALL MATADL(GL,R,L,L)
C     GL=(INVERSE OF GL) COMPUTATION
cc      CALL INVDET(GL,XDET,L,MJ2)
      CALL INVDET(GL,XDET,L,L)
C     G3=GL*GI COMPUTATION
cc      CALL MULPLY(GL,GI,G3,L,L,MR,MJ2,MJ2,MJ3)
      CALL MULPLY(GL,GI,G3,L,L,MR)
C     D= DIAGONAL OF P
      DO 30 I=1,MR
cxx   30 D(I)=P(I,I)
      D(I)=P(I,I)
   30 CONTINUE
C     INTERMEDIATE MATRIX MI COMPUTATION
C     P=(TRANSPOSE OF GI)*G3 (LOWER TRIANGLE) COMPUTATION
cc      CALL MULTRL(GI,G3,P,L,MR,MJ2,MJ3)
      CALL MULTRL(GI,G3,P,L,MR)
      DO 40 I=1,MR
cxx   40 P(I,I)=D(I)-P(I,I)
      P(I,I)=D(I)-P(I,I)
   40 CONTINUE
      IF(MR.EQ.1) GO TO 260
cxx      DO 41 I=2,MR
      DO 42 I=2,MR
      IM1=I-1
      DO 41 J=1,IM1
      P(I,J)=P(J,I)-P(I,J)
cxx   41 P(J,I)=P(I,J)
      P(J,I)=P(I,J)
   41 CONTINUE
   42 CONTINUE
C     GIT=MI*A COMPUTATION
cc  260 CALL MULPLY(P,A,GIT,MR,MR,IR,MJ3,MJ3,MJ1)
  260 CALL MULPLY(P,A,GIT,MR,MR,IR)
C     GR=(TRANSPOSE OF A)*GIT COMPUTATION
cc      CALL MULTRL(A,GIT,GR,MR,IR,MJ3,MJ1)
      CALL MULTRL(A,GIT,GR,MR,IR)
cxx      DO 150 I=1,IR
      DO 151 I=1,IR
      DO 150 J=1,I
cxx  150 GR(J,I)=GR(I,J)
      GR(J,I)=GR(I,J)
  150 CONTINUE
  151 CONTINUE
C     GR=GR+Q1 COMPUTATION
cc      CALL MATADL(GR,Q1,IR,IR,MJ1,MJ1)
      CALL MATADL(GR,Q1,IR,IR)
C     NEW P ARRANGEMENT
      IF(M.EQ.1) GO TO 261
      IIB=IBA
      DO 50 II=1,MM1
      II0=M-II
      JJC=IIB
      DO 51 JJ=1,II0
      DO 52 I=1,IR
      I1=IIB+I
      I2=I1+IR
CX      DO 52 J=1,IR
      DO 53 J=1,IR
      J1=JJC+J
      J2=J1+IR
      P(I2,J2)=P(I1,J1)
cxx   52 P(J2,I2)=P(I2,J2)
      P(J2,I2)=P(I2,J2)
   53 CONTINUE
   52 CONTINUE
cxx   51 JJC=JJC-IR
      JJC=JJC-IR
   51 CONTINUE
cxx   50 IIB=IIB-IR
      IIB=IIB-IR
   50 CONTINUE
      DO 57 I=1,MR1
      I1=I+IR
cxx      DO 57 J=1,IR
      DO 58 J=1,IR
      P(I1,J)=GIT(I,J)
cxx   57 P(J,I1)=P(I1,J)
      P(J,I1)=P(I1,J)
   58 CONTINUE
   57 CONTINUE
cxx  261 DO 56 I=1,IR
  261 DO 55 I=1,IR
      DO 56 J=1,I
      P(I,J)=GR(I,J)
cxx   56 P(J,I)=P(I,J)
      P(J,I)=P(I,J)
   56 CONTINUE
   55 CONTINUE
   10 CONTINUE
C
C     GAIN COMPUTATION
C     GLR=-G3*A
cc      CALL MULPLY(G3,A,GLR,L,MR,IR,MJ2,MJ3,MJ1)
      CALL MULPLY(G3,A,GLR,L,MR,IR)
cxx      DO 110 I=1,L
      DO 112 I=1,L
      DO 110 J=1,IR
cxx  110 GI(I,J)=-GLR(I,J)
      GI(I,J)=-GLR(I,J)
  110 CONTINUE
  112 CONTINUE
      IF(M.EQ.1) GO TO 262
cxx      DO 111 I=1,L
      DO 113 I=1,L
      DO 111 J=1,MR1
      J1=IR+J
cxx  111 GI(I,J1)=-G3(I,J)
      GI(I,J1)=-G3(I,J)
  111 CONTINUE
  113 CONTINUE
C     GAIN PRINT AND PUNCH OUT
  262 CONTINUE
cc  262 WRITE(6,67)
cc      CALL SUBMPR(GI,L,MR,MJ2,MJ3)
cc      WRITE(7,1) N,M,IR,L,NS
cc      DO 232 I=1,IR
cc  232 WRITE(7,2) (Q1(I,J),J=1,IR)
cc      DO 233 I=1,L
cc  233 WRITE(7,2) (R(I,J),J=1,L)
cc      DO 230 I=1,MR
cc  230 WRITE(7,2) (A(I,J),J=1,IR)
cc      DO 231 I=1,MR
cc  231 WRITE(7,2) (B(I,J),J=1,L)
cc      DO 120 I=1,L
cc  120 WRITE(7,2) (GI(I,J),J=1,MR)
cc      CALL FLCLS3(NFL)
cc  999 CONTINUE
      RETURN
cxx    1 FORMAT(10I5)
cxx    2 FORMAT(4D20.10)
cxx   60 FORMAT(1H ,41HPROGRAM 5.5.1   OPTIMAL CONTROLLER DESIGN)
cxx   61 FORMAT(1H ,17HINITIAL CONDITION)
cxx   62 FORMAT(1H ,3HIR=,I5,5X,2HL=,I5,5X,3HNS=,I5)
cxx  362 FORMAT(1H ,2HN=,I5,5X,2HM=,I5)
cxx   63 FORMAT(//1H ,44HFIRST IR COLUMNS OF TRANSITION MATRIX (AI'S))
cxx   64 FORMAT(//1H ,19HGAMMA MATRIX (BI'S))
cxx   65 FORMAT(//1H ,10X,7HQ1(I,J))
cxx   66 FORMAT(//1H ,10X,6HR(I,J))
cxx   67 FORMAT(////1H ,13HGAIN MATRIX G)
      END
C
cc	SUBROUTINE MULTRB(X,Y,Z,MM,NN,MJ1,MJ2)
      SUBROUTINE MULTRB(X,Y,Z,MM,NN)
C     Z=X*Y
C     Z: SYMMETRIC
C     (LOWER TRIANGLE OF UPPER LEFT MM X MM OF Z)=(UPPER LEFT MM X NN OF
C     X)*(UPPER LEFT NN X MM OF Y)
C     (MJ1,MJ2): ABSOLUTE DIMENSION OF X IN THE MAIN ROUTINE
C     (MJ2,MJ1): ABSOLUTE DIMENSION OF Y IN THE MAIN ROUTINE
C     (MJ1,MJ1): ABSOLUTE DIMENSION OF Z IN THE MAIN ROUTINE
cxx      IMPLICIT REAL*8(A-H,O-Z)
cc      DIMENSION X(MJ1,MJ2),Y(MJ2,MJ1),Z(MJ1,MJ1)
cxx      DIMENSION X(MM,NN),Y(NN,MM),Z(NN,NN)
      INTEGER :: MM, NN
      REAL(8) :: X(MM,NN), Y(NN,MM), Z(NN,NN)
      REAL(8) :: CST0, SUM
      CST0=0.0D-00
cxx      DO 10 I=1,MM
      DO 9 I=1,MM
      DO 10 J=1,I
      SUM=CST0
      DO 11 K=1,NN
cxx   11 SUM=SUM+X(I,K)*Y(K,J)
      SUM=SUM+X(I,K)*Y(K,J)
   11 CONTINUE
cxx   10 Z(I,J)=SUM
      Z(I,J)=SUM
   10 CONTINUE
    9 CONTINUE
      RETURN
      END
C
cc      SUBROUTINE MULTRL(X,Y,Z,MM,NN,MJ1,MJ2)
      SUBROUTINE MULTRL(X,Y,Z,MM,NN)
C     TRANSPOSE MULTIPLY (LEFT)
C     Z=X'*Y
C     Z: SYMMETRIC
C     (LOWER TRIANGLE OF UPPER LEFT NN X NN OF Z)=(UPPER LEFT MM X NN OF
C     X)'*(UPPER LEFT MM X NN OF Y)
C     (MJ1,MJ2): ABSOLUTE DIMENSION OF X AND Y IN THE MAIN ROUTINE
C     (MJ2,MJ2): ABSOLUTE DIMENSION OF Z IN THE MAIN ROUTINE
cxx      IMPLICIT REAL*8(A-H,O-Z)
cc      DIMENSION X(MJ1,MJ2),Y(MJ1,MJ2),Z(MJ2,MJ2)
cxx      DIMENSION X(MM,NN),Y(MM,NN),Z(NN,NN)
      INTEGER :: MM, NN
      REAL(8) :: X(MM,NN), Y(MM,NN), Z(NN,NN)
      REAL(8) :: CST0, SUM
      CST0=0.0D-00
cxx      DO 10 I=1,NN
      DO 9 I=1,NN
      DO 10 J=1,I
      SUM=CST0
      DO 11 K=1,MM
cxx   11 SUM=SUM+X(K,I)*Y(K,J)
      SUM=SUM+X(K,I)*Y(K,J)
   11 CONTINUE
cxx   10 Z(I,J)=SUM
      Z(I,J)=SUM
   10 CONTINUE
    9 CONTINUE
      RETURN
      END
