      SUBROUTINE WNOISEF(NRA,IR,SD1,X2)
C
      INCLUDE 'timsac.h'
C
cc      PROGRAM WNOISE
C     PROGRAM 5.5.3   WHITE NOISE GENERATOR
C-----------------------------------------------------------------------
C     ** DESIGNED BY H. AKAIKE, THE INSTITUTE OF STATISTICAL MATHEMATICS
C     ** PROGRAMMED BY E. ARAHATA, THE INSTITUTE OF STATISTICAL MATHEMAT
C         TOKYO
C     ** DATE OF THE LATEST REVISION: MARCH 25, 1977
C     ** THIS PROGRAM WAS ORIGINALLY PUBLISHED IN
C         "DAINAMIKKU SISTEMU NO TOKEI-TEKI KAISEKI TO SEIGYO (STATISTICA
C         ANALYSIS AND CONTROL OF DYNAMIC SYSTEMS)" BY H. AKAIKE AND
C         T. NAKAGAWA, SAIENSU-SHA, TOKYO, 1972 (IN JAPANESE)
C-----------------------------------------------------------------------
C     THIS PROGRAM GENERATES APPROXIMATELY GAUSSIAN VECTOR WHITE NOISE
C     TO BE USED AS INPUT W OF PROGRAM 5.5.2 OPTSIM.
C     ON TOP OF THE OUTPUT OF PROGRAM 5.3.2 FPEC, WHICH IS TO BE USED
C     AS INPUT TO PROGRAM 5.5.2 OPTSIM, ONE CARD WITH SPECIFICATION
C     OF THE LENGTH NRA OF WHITE NOISE RECORD TO BE GENERATED SHOULD
C     BE ADDED TO FORM THE INPUT TO THIS PROGRAM.
C     NRA: LENGTH OF WHITE NOISE RECORD TO BE GENERATED
C
cxx      IMPLICIT REAL*8(A-H,O-Z)
      PARAMETER (MJ0=100)
cc      REAL*4 RANDOM
ccc	 REAL*4	 RANDM
cxx      REAL*8 RANDM
cc      DIMENSION SD(5,5),A(10),Y(5),Z(5)
cc      DIMENSION X1(100,5)
cxx      DIMENSION SD1(IR,IR),SD(IR,IR),Y(IR),Z(IR)
cxx      DIMENSION X1(MJ0,IR),X2(IR,NRA)
      INTEGER NRA, IR
      DOUBLE PRECISION SD1(IR,IR), X2(IR,NRA)
c local
      DOUBLE PRECISION RANDM, SD(IR,IR), Y(IR), Z(IR), X1(MJ0,IR), CST0,
     1                 RC, RCONST, XX, SUM
C     INPUT / OUTPUT DATA FILE OPEN
cc      CHARACTER(100) DFNAM
cc      DFNAM = 'wnoise.out'
cc      CALL SETWND
cc      CALL FLOPN3(DFNAM,NFL)
cc      IF (NFL.EQ.0) GO TO 999
C     ABSOLUTE DIMENSIONS USED FOR SUBROUTINE CALL
cc      MJ0=100
cc      MJ=5
      CST0=0.0D-00
C     NRA SPECIFICATION
cc      READ(5,1) NRA
C     READING THE OUTPUTS OF PROGRAM 5.3.2 FPEC
cc      READ(5,1) N,M,IR,IL
cc      CALL REMATX(SD,IR,IR,1,MJ,MJ)
cxx      DO 5 I=1,IR
      DO 6 I=1,IR
         DO 5 J=1,IR
            SD(I,J)=SD1(I,J)
    5    CONTINUE
    6 CONTINUE
C     FOLLOWING INPUT IS NONEFFECTIVE.
cc      IP=IR+IL
cc      MR=M*IR
cc      DO 8 JJ=1,MR
cc    8 READ(5,2) (A(II),II=1,IP)
cc      WRITE(6,60)
cc      WRITE(6,61)
cc      WRITE(6,62) NRA,N,M,IR
cc      WRITE(6,63)
cc      CALL SUBMPR(SD,IR,IR,MJ,MJ)
cc      WRITE(6,100)
C     MATRIX L COMPUTATION
cc      CALL LTINV(SD,IR,MJ)
      CALL LTINV(SD,IR)
C     MATRIX L ARRANGEMENT
      IF(IR.EQ.1) GO TO 260
cxx      DO 12 I=2,IR
      DO 13 I=2,IR
      IM1=I-1
      DO 12 J=1,IM1
cxx   12 SD(I,J)=SD(J,I)
      SD(I,J)=SD(J,I)
   12 CONTINUE
   13 CONTINUE
C     RANDOM NUMBER GENERATION
  260 RC=4.0D-00/3.0D-00
      RCONST=DSQRT(RC)
cc      XX=RANDOM(1)
ccc      XX=RANDM(1)
      XX=RANDM(1,K1,K2,K3,K4)
cc      IND=99
      IND=MJ0-1
      IND1=IND+1
      I1=0
      I2=0
      IIC=0
  160 I1=I2+1
      I2=I1+IND
      IF(I2.LE.NRA) GO TO 130
      I2=NRA
  130 DO 14 I=I1,I2
      II=I-IIC
      DO 15 J=1,IR
      SUM=CST0
      DO 20 JJ=1,9
cc   20 SUM=SUM+RANDOM(0)
ccc   20 SUM=SUM+RANDM(0)
cxx   20 SUM=SUM+RANDM(0,K1,K2,K3,K4)
      SUM=SUM+RANDM(0,K1,K2,K3,K4)
   20 CONTINUE
      SUM=SUM-4.5D-00
cxx   15 X1(II,J)=SUM*RCONST
      X1(II,J)=SUM*RCONST
   15 CONTINUE
   14 CONTINUE
C     WHITE NOISE GENERATION
      DO 16 I=I1,I2
      II=I-IIC
      DO 17 J=1,IR
cxx   17 Y(J)=X1(II,J)
      Y(J)=X1(II,J)
   17 CONTINUE
cc      CALL LTRVEC(SD,Y,Z,IR,IR,MJ,MJ)
      CALL LTRVEC(SD,Y,Z,IR,IR)
      DO 18 J=1,IR
cxx   18 X1(II,J)=Z(J)
      X1(II,J)=Z(J)
   18 CONTINUE
   16 CONTINUE
C     WHITE NOISE PRINT AND PUNCH OUT
cc      WRITE(6,101) IIC
      I3=I2-IIC
cc      CALL SUBMPR(X1,I3,IR,MJ0,MJ)
cxx      DO 40 I=I1,I2
      DO 41 I=I1,I2
         II=I-IIC
cc   40 WRITE(7,3) (X1(II,J),J=1,IR)
      DO 40 J=1,IR
cxx   40 X2(J,I)=X1(II,J)
      X2(J,I)=X1(II,J)
   40 CONTINUE
   41 CONTINUE
      IIC=IIC+IND1
      IF(I2.LT.NRA) GO TO 160
cc      CALL FLCLS3(NFL)
cc  999 CONTINUE
      RETURN
cxx    1 FORMAT(10I5)
cxx    2 FORMAT(4D20.10)
cxx    3 FORMAT(6D12.3)
cxx   60 FORMAT(1H ,27HPROGRAM 5.5.3   WHITE NOISE)
cxx   61 FORMAT(1H ,17HINITIAL CONDITION)
cxx   62 FORMAT(1H ,4HNRA=,I5,5X,2HN=,I5,5X,2HM=,I5,5X,3HIR=,I5)
cxx   63 FORMAT(/1H ,7HSD(I,J))
cxx  100 FORMAT(////1H ,11HWHITE NOISE)
cxx  101 FORMAT(1H ,4HIIC=,I5,5X,11HX1(IIC+I,J))
      END
