% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tinyplot_add.R
\name{tinyplot_add}
\alias{tinyplot_add}
\alias{plt_add}
\title{Add new elements to the current \code{tinyplot}}
\usage{
tinyplot_add(...)

plt_add(...)
}
\arguments{
\item{...}{All named arguments override arguments from the previous calls.
Arguments not supplied to \link{tinyplot_add} remain unchanged from the previous
call.}
}
\value{
No return value, called for side effect of producing a plot.
}
\description{
This convenience function grabs the preceding \code{tinyplot} call and updates it
with any new arguments that have been explicitly provided by the user. It
then injects \code{add=TRUE} and evaluates the updated call, thereby drawing a new
layer on top of the existing plot. \code{plt_add()} is a shorthand alias for
\code{tinyplot_add()}.
}
\section{Limitations}{

\itemize{
\item \code{tinyplot_add()} works reliably only when adding to a plot originally
created using the \code{\link{tinyplot.formula}} method with a valid \code{data} argument.
We cannot guarantee correct behavior if the original plot was created with
the atomic \code{\link{tinyplot.default}} method, due to potential environment
mismatches. (An exception is when the original plot arguments---\code{x}, \code{y},
etc.---are located in the global environment.)
\item There are two important limitations when adding layers to \emph{faceted} plots:
\itemize{
\item Avoid resizing the graphics window after the first layer is drawn, since
it will lead to any subsequent layers being misaligned. This is a
limitation of base R's \code{graphics} engine and cannot be reliably preempted
or corrected by \code{tinyplot}. Note that resizing non-faceted plots is
always fine, though. See:
\url{https://github.com/grantmcdermott/tinyplot/issues/313}
\item On Positron, specifically, alignment issues may occur even without
resizing. A warning will be triggered when (i) Positron is detected and
(ii) a user attempts to add layers to a faceted plot. Again, this issue
is not present for non-faceted plots. See the upstream bug report:
\url{https://github.com/posit-dev/positron/issues/7316}
}
\item Automatic legends for the added elements will be turned off.
}
}

\examples{
tinyplot(Sepal.Width ~ Sepal.Length | Species,
  facet = ~Species,
  data = iris)

tinyplot_add(type = "lm") ## or : plt_add(type = "lm")

## Note: the previous function is equivalent to (but much more convenient
## than) re-writing the full call with the new type and `add=TRUE`:

# tinyplot(Sepal.Width ~ Sepal.Length | Species,
#          facet = ~Species,
#          data = iris,
#          type = "lm",
#          add = TRUE)

}
