% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pali-sort.R
\name{pali_sort}
\alias{pali_sort}
\title{Sorting function for vectors of Pali words.}
\usage{
pali_sort(word_list)
}
\arguments{
\item{word_list}{A vector of Pali words}
}
\value{
A new vector of Pali words in Pali alphabetical order
}
\description{
Note that all Pali string comparisons are case-insensitive.
This algorithm is based on Quicksort, but creates lots of
intermediate data structures instead of doing swaps in place.
It is MUCH slower than the built-in sort, but respects Pali
alphabetical order. (It takes about 60 seconds to sort 10,000
random Pali words on my Mac; sort takes less than 1 sec!)
}
\examples{
# Every unique word of of the Mahāsatipatthāna Sutta in
# Pali alphabetical order -- warning, can be slow!
\donttest{
pali_sort(sati_sutta_long$word)
}

# A sorted list of 100 random words from the Tiptaka
library(dplyr)
pali_sort(sample(tipitaka_long$word, 100))

}
