% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inline_coef.R
\name{inline_coef}
\alias{inline_coef}
\alias{inline_coef_p}
\title{Report the coefficient from a regression model inline}
\usage{
inline_coef(model, variable, coef = TRUE, stat = TRUE, pval = TRUE, digits = 2)

inline_coef_p(model, variable, digits = 2)
}
\arguments{
\item{model}{A regression model}

\item{variable}{A character string giving the name of the variable to be reported}

\item{coef}{Logical, whether the coefficient value is to be reported (default TRUE)}

\item{stat}{Logical, whether the test statistic for the coefficient should be reported (default TRUE)}

\item{pval}{Logical, whether the p-value for the coefficient should be reported (default TRUE)}

\item{digits}{Number of digits to round to (default to 2)}
}
\value{
Returns a LaTeX-formatted result for use in RMarkdown document.
}
\description{
\code{inline_coef} presents the resuts of a coefficient from a \code{lm} or \code{glm} model in LaTeX format to be reported inline in an RMarkdown document.
}
\details{
This function currently only supports \code{lm} and \code{glm} objects. Suggestions and requests are welcomed.

\code{inline_coef_p} is a wrapper for \code{inline_coef} to report only the p-value (sets all non-p-value logicals to FALSE).
}
\examples{
x1 = rnorm(20)
x2 = rnorm(20)
y = x1 + x2 + rnorm(20)
model1 = lm(y ~ x1 + x2)
inline_coef(model1, 'x1')
inline_coef_p(model1, 'x1')

}
