% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_method_12_kRp.corpus-class_cTest.R
\docType{methods}
\name{cTest,kRp.corpus-method}
\alias{cTest,kRp.corpus-method}
\title{Apply cTest() to all texts in kRp.corpus objects}
\usage{
\S4method{cTest}{kRp.corpus}(obj, mc.cores = getOption("mc.cores", 1L), ...)
}
\arguments{
\item{obj}{An object of class \code{\link[tm.plugin.koRpus:kRp.corpus-class]{kRp.corpus}}.}

\item{mc.cores}{The number of cores to use for parallelization,
      see \code{\link[parallel:mclapply]{mclapply}}.}

\item{...}{options to pass through to \code{\link[koRpus:cTest]{cTest}}.}
}
\value{
An object of the same class as \code{obj}.
}
\description{
This method calls \code{\link[koRpus:cTest]{cTest}} on all tagged text objects
inside the given \code{obj} object (using \code{mclapply}).
}
\examples{
# use readCorpus() to create an object of class kRp.corpus
# code is only run when the english language package can be loaded
if(require("koRpus.lang.en", quietly = TRUE)){
  myCorpus <- readCorpus(
    dir=file.path(
      path.package("tm.plugin.koRpus"), "examples", "corpus", "Edwards"
    ),
    hierarchy=list(
      Source=c(
        Wikipedia_prev="Wikipedia (old)",
        Wikipedia_new="Wikipedia (new)"
      )
    ),
    # use tokenize() so examples run without a TreeTagger installation
    tagger="tokenize",
    lang="en"
  )

  taggedText(myCorpus)[20:30,]
  myCorpus <- cTest(myCorpus)
  taggedText(myCorpus)[20:30,]
} else {}
}
