% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_layers.R
\name{tm_symbols}
\alias{tm_symbols}
\alias{tm_squares}
\alias{tm_bubbles}
\alias{tm_dots}
\alias{tm_markers}
\title{Draw symbols}
\usage{
tm_symbols(size = 1, col = NA, shape = 21, alpha = NA,
  border.col = NA, border.lwd = 1, border.alpha = NA, scale = 1,
  perceptual = FALSE, size.max = NA, size.lim = NA, sizes.legend = NULL,
  sizes.legend.labels = NULL, n = 5, style = ifelse(is.null(breaks),
  "pretty", "fixed"), breaks = NULL, interval.closure = "left",
  palette = NULL, labels = NULL, auto.palette.mapping = TRUE,
  contrast = NA, max.categories = 12, colorNA = NA, textNA = "Missing",
  showNA = NA, shapes = 21:25, shapes.legend = NULL,
  shapes.legend.fill = NA, shapes.labels = NULL, shapeNA = 4,
  shape.textNA = "Missing", shapes.n = 5,
  shapes.style = ifelse(is.null(shapes.breaks), "pretty", "fixed"),
  shapes.breaks = NULL, shapes.interval.closure = "left",
  legend.max.symbol.size = 0.8, just = NA, jitter = 0, xmod = 0,
  ymod = 0, icon.scale = 3, grob.dim = c(width = 48, height = 48,
  render.width = 256, render.height = 256), title.size = NA, title.col = NA,
  title.shape = NA, legend.size.show = TRUE, legend.col.show = TRUE,
  legend.shape.show = TRUE, legend.format = list(),
  legend.size.is.portrait = FALSE, legend.col.is.portrait = TRUE,
  legend.shape.is.portrait = TRUE, legend.hist = FALSE,
  legend.hist.title = NA, legend.size.z = NA, legend.col.z = NA,
  legend.shape.z = NA, legend.hist.z = NA, id = NA, popup.vars = NA,
  popup.format = list())

tm_squares(size = 1, col = NA, shape = 22, scale = 4/3, ...)

tm_bubbles(size = 1, col = NA, shape = 21, scale = 4/3,
  legend.max.symbol.size = 1, ...)

tm_dots(col = NA, size = 0.02, shape = 16, title = NA,
  legend.show = TRUE, legend.is.portrait = TRUE, legend.z = NA, ...)

tm_markers(shape = marker_icon(), col = NA, border.col = NULL,
  text = NULL, text.just = c("center", "top"),
  markers.on.top.of.text = TRUE, ...)
}
\arguments{
\item{size}{a single value or a \code{shp} data variable that determines the symbol sizes. The reference value \code{size=1} corresponds to the area of symbols that have the same height as one line of text. If a data variable is provided, the symbol sizes are scaled proportionally (or perceptually, see \code{perceptual}) where by default the symbol with the largest data value will get \code{size=1} (see also \code{size.max}). If multiple values are specified, small multiples are drawn (see details).}

\item{col}{color(s) of the symbol. Either a color (vector), or categorical variable name(s). If multiple values are specified, small multiples are drawn (see details).}

\item{shape}{shape(s) of the symbol. Either direct shape specification(s) or a data variable name(s) that is mapped to the symbols specified by the \code{shapes} argument. See details for the shape specification.}

\item{alpha}{transparency number between 0 (totally transparent) and 1 (not transparent). By default, the alpha value of the \code{col} is used (normally 1).}

\item{border.col}{color of the symbol borders.}

\item{border.lwd}{line width of the symbol borders. If \code{NA}, no symbol borders are drawn.}

\item{border.alpha}{transparency number, regarding the symbol borders, between 0 (totally transparent) and 1 (not transparent). By default, the alpha value of the \code{col} is used (normally 1).}

\item{scale}{symbol size multiplier number.}

\item{perceptual}{logical that determines whether symbols are scales with a perceptually (\code{TRUE}) or mathematically (\code{FALSE}, default value). The perceived area of larger symbols is often underestimated. Flannery (1971) experimentally derived a method to compensate this for symbols, which is enabled by this argument.}

\item{size.max}{value that is mapped to \code{size=1}. By default (\code{NA}), the maximum data value is chosen. Only applicable when \code{size} is the name of a numeric variable of \code{shp}}

\item{size.lim}{vector of two limit values of the \code{size} variable. Only symbols are drawn whose value is greater than or equal to the first value. Symbols whose values exceed the second value are drawn at the size of the second value. Only applicable when \code{size} is the name of a numeric variable of \code{shp}}

\item{sizes.legend}{vector of symbol sizes that are shown in the legend. By default, this is determined automatically.}

\item{sizes.legend.labels}{vector of labels for that correspond to \code{sizes.legend}.}

\item{n}{preferred number of color scale classes. Only applicable when \code{col} is a numeric variable name.}

\item{style}{method to process the color scale when \code{col} is a numeric variable. Discrete options are \code{"cat"}, \code{"fixed"}, \code{"sd"}, \code{"equal"}, \code{"pretty"}, \code{"quantile"}, \code{"kmeans"}, \code{"hclust"}, \code{"bclust"}, \code{"fisher"}, and \code{"jenks"}. A numeric variable is processed as a categorial variable when using \code{"cat"}, i.e. each unique value will correspond to a distinct category. For the other discrete options, see the details in \code{\link[classInt:classIntervals]{classIntervals}}. Continuous options are \code{"cont"} and \code{"order"}. The former maps the values of \code{col} to a smooth gradient, whereas the latter maps the order of values of \code{col} to a smooth gradient. They are the continuous variants of respectively the discrete methods "equal" and quantile".}

\item{breaks}{in case \code{style=="fixed"}, breaks should be specified. The \code{breaks} argument can also be used when \code{style="cont"}. In that case, the breaks are mapped evenly to the sequential or divering color palette.}

\item{interval.closure}{value that determines whether where the intervals are closed: \code{"left"} or \code{"right"}. Only applicable if \code{col} is a numerc variable.}

\item{palette}{a palette name or a vector of colors. See \code{tmaptools::palette_explorer()} for the named palettes. Use a \code{"-"} as prefix to reverse the palette. The default palette is taken from \code{\link{tm_layout}}'s argument \code{aes.palette}, which typically depends on the style. The type of palette from \code{aes.palette} is automatically determined, but can be overwritten: use \code{"seq"} for sequential, \code{"div"} for diverging, and \code{"cat"} for categorical.}

\item{labels}{labels of the classes}

\item{auto.palette.mapping}{When diverging colour palettes are used (i.e. "RdBu") this method automatically maps colors to values such that the middle colors (mostly white or yellow) are assigned to values of 0, and the two sides of the color palette are assigned to negative respectively positive values. When categorical color palettes are used, this method stretches the palette if there are more levels than colors.}

\item{contrast}{vector of two numbers that determine the range that is used for sequential and diverging palettes (applicable when \code{auto.palette.mapping=TRUE}). Both numbers should be between 0 and 1. The first number determines where the palette begins, and the second number where it ends. For sequential palettes, 0 means the brightest color, and 1 the darkest color. For diverging palettes, 0 means the middle color, and 1 both extremes. If only one number is provided, this number is interpreted as the endpoint (with 0 taken as the start).}

\item{max.categories}{in case \code{col} is the name of a categorical variable, this value determines how many categories (levels) it can have maximally. If the number of levels is higher than \code{max.categories} and \code{auto.palette.mapping} is \code{FALSE}, then levels are combined.}

\item{colorNA}{colour for missing values. Use \code{NULL} for transparency.}

\item{textNA}{text used for missing values of the color variable.}

\item{showNA}{logical that determines whether missing values are named in the legend. By default (\code{NA}), this depends on the presence of missing values.}

\item{shapes}{palette of symbol shapes. Only applicable if \code{shape} is a (vector of) categorical variable(s). See details for the shape specification. By default, the filled symbols 21 to 25 are taken.}

\item{shapes.legend}{symbol shapes that are used in the legend (instead of the symbols specified with \code{shape}. Especially useful when \code{shapes} consist of grobs that have to be represented by neutrally colored shapes (see also \code{shapes.legend.fill}.}

\item{shapes.legend.fill}{Fill color of legend shapes (see \code{shapes.legend})}

\item{shapes.labels}{Legend labels for the symbol shapes}

\item{shapeNA}{the shape (a number or grob) for missing values. By default a cross (number 4).}

\item{shape.textNA}{text used for missing values of the shape variable.}

\item{shapes.n}{preferred number of shape classes. Only applicable when \code{shape} is a numeric variable name.}

\item{shapes.style}{method to process the shape scale when \code{shape} is a numeric variable. See \code{style} argument for options}

\item{shapes.breaks}{in case \code{shapes.style=="fixed"}, breaks should be specified}

\item{shapes.interval.closure}{value that determines whether where the intervals are closed: \code{"left"} or \code{"right"}. Only applicable if \code{shape} is a numerc variable.}

\item{legend.max.symbol.size}{Maximum size of the symbols that are drawn in the legend. For circles and bubbles, a value larger than one is recommended (and used for \code{tm_bubbles})}

\item{just}{justification of the symbols relative to the point coordinates.  The first value specifies horizontal and the second value vertical justification. Possible values are: \code{"left"} , \code{"right"}, \code{"center"}, \code{"bottom"}, and \code{"top"}. Numeric values of 0 specify left alignment and 1 right alignment. The default value is \code{c("center", "center")}. For icons, this value may already be speficied (see \code{\link{tmap_icons}}). The \code{just}, if specified, will overrides this.}

\item{jitter}{number that determines the amount of jittering, i.e. the random noise added to the position of the symbols. 0 means no jittering is applied, any positive number means that the random noise has a standard deviation of \code{jitter} times the height of one line of text line.}

\item{xmod}{horizontal position modification of the symbols, in terms of the height of one line of text. Either a single number for all polygons, or a numeric variable in the shape data specifying a number for each polygon. Together with \code{ymod}, it determines position modification of the symbols. See also \code{jitter} for random position modifications. In most coordinate systems (projections), the origin is located at the bottom left, so negative \code{xmod} move the symbols to the left, and negative \code{ymod} values to the bottom.}

\item{ymod}{vertical position modification. See xmod.}

\item{icon.scale}{scaling number that determines how large the icons (or grobs) are in plot mode in comparison to proportional symbols (such as bubbles). In view mode, the size is determined by the icon specification (see \code{\link{tmap_icons}}) or, if grobs are specified by \code{grob.width} and \code{grob.heigth}}

\item{grob.dim}{vector of four values that determine how grob objects (see details) are shown in view mode. The first and second value are the width and height of the displayed icon. The third and fourth value are the width and height of the rendered png image that is used for the icon. Generally, the third and fourth value should be large enough to render a ggplot2 graphic succesfully. Only needed for the view mode.}

\item{title.size}{title of the legend element regarding the symbol sizes}

\item{title.col}{title of the legend element regarding the symbol colors}

\item{title.shape}{title of the legend element regarding the symbol shapes}

\item{legend.size.show}{logical that determines whether the legend for the symbol sizes is shown}

\item{legend.col.show}{logical that determines whether the legend for the symbol colors is shown}

\item{legend.shape.show}{logical that determines whether the legend for the symbol shapes is shown}

\item{legend.format}{list of formatting options for the legend numbers. Only applicable if \code{labels} is undefined. Parameters are:
\describe{
\item{fun}{Function to specify the labels. It should take a numeric vector, and should return a character vector of the same size. By default it is not specified. If specified, the list items \code{scientific}, \code{format}, and \code{digits} (see below) are not used.}
\item{scientific}{Should the labels be formatted scientically? If so, square brackets are used, and the \code{format} of the numbers is \code{"g"}. Otherwise, \code{format="f"}, and \code{text.separator}, \code{text.less.than}, and \code{text.or.more} are used. Also, the numbers are automatically  rounded to millions or billions if applicable.}
\item{format}{By default, \code{"f"}, i.e. the standard notation \code{xxx.xxx}, is used. If \code{scientific=TRUE} then \code{"g"}, which means that numbers are formatted scientically, i.e. \code{n.dddE+nn} if needed to save space.}
\item{digits}{Number of digits after the decimal point if \code{format="f"}, and the number of significant digits otherwise.}
\item{text.separator}{Character string to use to separate numbers in the legend (default: "to").}
\item{text.less.than}{Character string to use to translate "Less than" (which is the default).}
\item{text.or.more}{Character string to use to translate "or more" (which is the default). }
\item{...}{Other arguments passed on to \code{\link[base:formatC]{formatC}}}
}}

\item{legend.size.is.portrait}{logical that determines whether the legend element regarding the symbol sizes is in portrait mode (\code{TRUE}) or landscape (\code{FALSE})}

\item{legend.col.is.portrait}{logical that determines whether the legend element regarding the symbol colors is in portrait mode (\code{TRUE}) or landscape (\code{FALSE})}

\item{legend.shape.is.portrait}{logical that determines whether the legend element regarding the symbol shapes is in portrait mode (\code{TRUE}) or landscape (\code{FALSE})}

\item{legend.hist}{logical that determines whether a histogram is shown regarding the symbol colors}

\item{legend.hist.title}{title for the histogram. By default, one title is used for both the histogram and the normal legend for symbol colors.}

\item{legend.size.z}{index value that determines the position of the legend element regarding the symbol sizes with respect to other legend elements. The legend elements are stacked according to their z values. The legend element with the lowest z value is placed on top.}

\item{legend.col.z}{index value that determines the position of the legend element regarding the symbol colors. (See \code{legend.size.z})}

\item{legend.shape.z}{index value that determines the position of the legend element regarding the symbol shapes. (See \code{legend.size.z})}

\item{legend.hist.z}{index value that determines the position of the histogram legend element. (See \code{legend.size.z})}

\item{id}{name of the data variable that specifies the indices of the symbols. Only used for \code{"view"} mode (see \code{\link{tmap_mode}}).}

\item{popup.vars}{names of data variables that are shown in the popups in \code{"view"} mode. If \code{NA} (default), only aesthetic variables (i.e. specified by \code{col} and \code{lwd}) are shown). If they are not specified, all variables are shown. Set popup.vars to \code{FALSE} to disable popups. When a vector of variable names is provided, the names (if specified) are printed in the popups.}

\item{popup.format}{list of formatting options for the popup values. See the argument \code{legend.format} for options. Only applicable for numeric data variables. If one list of formatting options is provided, it is applied to all numeric variables of \code{popup.vars}. Also, a (named) list of lists can be provided. In that case, each list of formatting options is applied to the named variable.}

\item{...}{arguments passed on to \code{tm_symbols}. For \code{tm_markers}, arguments can also be passed on to \code{tm_text}. In that case, they have to be prefixed with \code{text.}, e.g. the \code{col} argument should be names \code{text.col}}

\item{title}{shortcut for \code{title.col} for \code{tm_dots}}

\item{legend.show}{shortcut for \code{legend.col.show} for \code{tm_dots}}

\item{legend.is.portrait}{shortcut for \code{legend.col.is.portrait} for \code{tm_dots}}

\item{legend.z}{shortcut for \code{legend.col.z shortcut} for \code{tm_dots}}

\item{text}{text of the markers. Shown in plot mode, and as popup text in view mode.}

\item{text.just}{justification of marker text (see \code{just} argument of \code{\link{tm_text}}). Only applicable in plot mode.}

\item{markers.on.top.of.text}{For \code{tm_markers}, should the markers be drawn on top of the text labels?}
}
\value{
\code{\link{tmap-element}}
}
\description{
Creates a \code{\link{tmap-element}} that draws symbols, including symbols and dots. The color, size, and shape of the symbols can be mapped to data variables.
}
\details{
Small multiples can be drawn in two ways: either by specifying the \code{by} argument in \code{\link{tm_facets}}, or by defining multiple variables in the aesthetic arguments, which are \code{size}, \code{col}, and \code{shape}. In the latter case, the arguments, except for the ones starting with \code{legend.}, can be specified for small multiples as follows. If the argument normally only takes a single value, such as \code{n}, then a vector of those values can be specified, one for each small multiple. If the argument normally can take a vector, such as \code{palette}, then a list of those vectors (or values) can be specified, one for each small multiple.

A  shape specification is one of the following three options. To specify multiple shapes, a vector or list of these shape specification is required. The shape specification options can also be mixed.
\enumerate{
 \item{A numeric value that specifies the plotting character of the symbol. See parameter \code{pch} of \code{\link[graphics:points]{points}} and the last example to create a plot with all options.}
 \item{A \code{\link[grid:grid.grob]{grob}} object, which can be a ggplot2 plot object created with \code{\link[ggplot2:ggplotGrob]{ggplotGrob}}. To specify multiple shapes, a list of grob objects is required. See example of a proportional symbol map with ggplot2 plots}.
 \item{An icon specification, which can be created with \code{\link{tmap_icons}}.}
 }
}
\examples{
data(World, Europe, metro)
metro$growth <- (metro$pop2020 - metro$pop2010) / (metro$pop2010 * 10) * 100

tm_shape(World) +
    tm_fill("grey70") +
tm_shape(metro) +
    tm_bubbles("pop2010", col = "growth", 
        border.col = "black", border.alpha = .5, 
        style="fixed", breaks=c(-Inf, seq(0, 6, by=2), Inf),
        palette="-RdYlBu", contrast=1, 
        title.size="Metro population", 
        title.col="Growth rate (\%)") + 
tm_format_World()

tm_shape(metro) +
	tm_symbols(size = "pop2010", col="pop2010", shape="pop2010") +
tm_layout(legend.outside = TRUE, legend.outside.position = "bottom", legend.stack = "horizontal")

\dontrun{
require(tmaptools)
x <- sample_dots(World, vars="gdp_md_est", convert2density = TRUE, w = 100000)
tm_shape(x) + 
	tm_dots() + 
tm_layout("World GDP (one dot is 100 billon dollars)", title.position = c("right", "bottom"))
}

qtm(Europe, bbox="Italy") +
tm_shape(metro) +
	tm_markers(text="name")


if (require(ggplot2) && require(dplyr) && require(tidyr) && require(tmaptools)) {
data(NLD_prov)

origin_data <- NLD_prov@data \%>\% 
mutate(FID= factor(1:n())) \%>\% 
select(FID, origin_native, origin_west, origin_non_west) \%>\% 
gather(key=origin, value=perc, origin_native, origin_west, origin_non_west, factor_key=TRUE)

origin_cols <- get_brewer_pal("Dark2", 3)

grobs <- lapply(split(origin_data, origin_data$FID), function(x) {
ggplotGrob(ggplot(x, aes(x="", y=-perc, fill=origin)) +
	geom_bar(width=1, stat="identity") +
	scale_y_continuous(expand=c(0,0)) +
	scale_fill_manual(values=origin_cols) +
	theme_ps(plot.axes = FALSE))
})

tm_shape(NLD_prov) +
tm_polygons() +
tm_symbols(size="population", shape="name", 
	shapes=grobs, 
	sizes.legend=c(.5, 1,3)*1e6, 
	scale=1, 
	legend.shape.show = FALSE, 
	legend.size.is.portrait = TRUE, 
	shapes.legend = 22, 
	title.size = "Population",
	id = "name",
	popup.vars = c("population", "origin_native",
				   "origin_west", "origin_non_west")) +
tm_add_legend(type="fill", 
	col=origin_cols, 
	labels=c("Native", "Western", "Non-western"), 
	title="Origin") +
tm_format_NLD()	
}



# TIP: check out these examples in view mode, enabled with tmap_mode("view")

\dontrun{
if (require(rnaturalearth)) {

airports <- ne_download(scale=10, type="airports")
airplane <- tmap_icons(paste0("http://cdn.mysitemyway.com/etc-mysitemyway/icons/",
	"legacy-previews/icons-256/retro-green-floral-icons-transport-travel/",
	"040553-retro-green-floral-icon-transport-travel-transportation-airplane22.png"))

tmap_mode("view")
tm_shape(airports, bbox="Germany") +
	tm_symbols(shape=airplane, size="natlscale",
		legend.size.show = FALSE, scale=2, border.col = NULL, id="name", popup.vars = TRUE)
}
}

#####################################################################################

\dontrun{
# plot all available symbol shapes:
if (require(ggplot2)) {
	ggplot(data.frame(p=c(0:25,32:127))) +
	geom_point(aes(x=p\%\%16, y=-(p\%/\%16), shape=p), size=5, fill="red") +
	geom_text(mapping=aes(x=p\%\%16, y=-(p\%/\%16+0.25), label=p), size=3) +
	scale_shape_identity() +
	theme(axis.title=element_blank(),
		  axis.text=element_blank(),
		  axis.ticks=element_blank(),
		  panel.background=element_blank())
}
}
}
\references{
Flannery J (1971). The Relative Effectiveness of Some Common Graduated Point Symbols in the Presentation of Quantitative Data. Canadian Cartographer, 8 (2), 96-109.
}
\seealso{
\href{../doc/tmap-nutshell.html}{\code{vignette("tmap-nutshell")}}
}
\keyword{map}
\keyword{symbol}
