% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_raster.R
\name{poly_to_raster}
\alias{poly_to_raster}
\title{Convert spatial polygons to a raster}
\usage{
poly_to_raster(shp, nrow = NA, ncol = NA, N = 250000, use.cover = FALSE,
  to.Raster = FALSE, ...)
}
\arguments{
\item{shp}{shape object. Either a \code{\link[sp:SpatialPointsDataFrame]{SpatialPoints(DataFrame)}} or a \code{\link[sp:SpatialGridDataFrame]{SpatialGrid(DataFrame)}}.}

\item{nrow}{number of raster rows. If \code{NA}, it is automatically determined by \code{N} and the aspect ratio of \code{shp}.}

\item{ncol}{number of raster columns. If \code{NA}, it is automatically determined by \code{N} and the aspect ratio of \code{shp}.}

\item{N}{preferred number of raster cells.}

\item{use.cover}{logical; should the cover method be used? This method determines per raster cell which polygon has the highest cover fraction. This method is better, but very slow, since N times the number of polygons combinations are processed (using the \code{getCover} argument of \code{\link[raster:rasterize]{rasterize}}). By default, when a raster cell is covered by multiple polygons, the last polygon is taken (see \code{fun} argment of \code{\link[raster:rasterize]{rasterize}}))}

\item{to.Raster}{logical; should the output be a \code{\link[raster:Raster-class]{Raster}} object (\code{TRUE}), or a \code{\link[sp:SpatialGridDataFrame]{SpatialGridDataFrame}} (\code{FALSE}). If \code{TRUE}, a \code{RasterBrick} is returned when \code{by} is specified, and a \code{RasterLayer} when \code{by} is unspecified.}

\item{...}{arguments passed on to \code{\link[raster:rasterize]{rasterize}}}
}
\value{
A \code{\link[sp:SpatialGridDataFrame]{SpatialGridDataFrame}}, or a \code{\link[raster:Raster-class]{Raster}} object when (\code{to.Raster=TRUE})
}
\description{
Convert spatial polygons to a raster. For each raster cell, the data of the corresponding polygon is copied.
}
\examples{
\dontrun{
	data(NLD_muni)
	
	# choropleth of 65+ population percentages
	qtm(NLD_muni, fill="pop_65plus", format="NLD")
	
	# rasterized version
	NLD_rst <- poly_to_raster(NLD_muni)
	qtm(NLD_rst, raster="pop_65plus", format="NLD")
}
}
\seealso{
\code{\link{points_to_raster}}
}

