% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simplify_shape.R
\name{simplify_shape}
\alias{simplify_shape}
\title{Simplify shape}
\usage{
simplify_shape(shp, fact = 0.1, keep.units = FALSE, keep.subunits = FALSE, ...)
}
\arguments{
\item{shp}{an \code{\link[sf:sf]{sf}} or \code{\link[sf:sfc]{sfc}}  object.}

\item{fact}{simplification factor, number between 0 and 1 (default is 0.1)}

\item{keep.units}{prevent small polygon features from disappearing at high simplification (default FALSE)}

\item{keep.subunits}{should multipart polygons be converted to singlepart polygons? This prevents small shapes from disappearing during simplification if keep.units = TRUE. Default FALSE}

\item{...}{other arguments passed on to the underlying function \code{\link[rmapshaper:ms_simplify]{ms_simplify}} (except for the arguments \code{input}, \code{keep}, \code{keep_shapes} and \code{explode})}
}
\value{
\code{\link[sf:sf]{sf}} object
}
\description{
Simplify a shape consisting of polygons or lines. This can be useful for shapes that are too detailed for visualization, especially along natural borders such as coastlines and rivers. The number of coordinates is reduced.
}
\details{
This function is a wrapper of \code{\link[rmapshaper:ms_simplify]{ms_simplify}}. In addition, the data is preserved. Also \code{\link[sf:sf]{sf}} objects are supported.
}
\examples{
\dontrun{
if (require(tmap)) {
    data(World)

    # show different simplification factors
    tm1 <- qtm(World \%>\% simplify_shape(fact = 0.05), title="Simplify 0.05")
    tm2 <- qtm(World \%>\% simplify_shape(fact = 0.1), title="Simplify 0.1")
    tm3 <- qtm(World \%>\% simplify_shape(fact = 0.2), title="Simplify 0.2")
    tm4 <- qtm(World \%>\% simplify_shape(fact = 0.5), title="Simplify 0.5")
    tmap_arrange(tm1, tm2, tm3, tm4)

    # show different options for keeping smaller (sub)units
    tm5 <- qtm(World \%>\% simplify_shape(keep.units = TRUE, keep.subunits = TRUE),
        title="Keep units and subunits")
    tm6 <- qtm(World \%>\% simplify_shape(keep.units = TRUE, keep.subunits = FALSE),
        title="Keep units, ignore small subunits")
    tm7 <- qtm(World \%>\% simplify_shape(keep.units = FALSE),
        title="Ignore small units and subunits")
    tmap_arrange(tm5, tm6, tm7)
}
}

}
