% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multivariate.R
\name{tmodTagcloud}
\alias{tmodTagcloud}
\title{Tag cloud based on tmod results}
\usage{
tmodTagcloud(
  results,
  filter = TRUE,
  simplify = TRUE,
  tag.col = "Title",
  min.auc = 0.5,
  max.qval = 0.05,
  plot = TRUE,
  weights.col = "auto",
  pval.col = "P.Value",
  maxn = NULL,
  ...
)
}
\arguments{
\item{results}{data frame produced by one of the tmod enrichment tests}

\item{filter}{Whether redundant and not annotated modules should be removed}

\item{simplify}{Whether module names should be simplified}

\item{tag.col}{Which column from results should be used as tags on the plot}

\item{min.auc}{Minimal AUC to show (default: 0.5)}

\item{max.qval}{Maximal adjusted p value to show (default: 0.05)}

\item{plot}{Should the tag cloud be plotted or only returned}

\item{weights.col}{Which column from results should be used as weights for the tag cloud}

\item{pval.col}{Which column contains the P values which will be used to shade the tags}

\item{maxn}{Maximum number of gene set enrichment terms shown on the plot (if NULL – default – all terms will be shown)}

\item{...}{Any further parameters are passed to the tagcloud function}
}
\value{
Either NULL or whatever tagcloud returns
}
\description{
Plot a tag (word) cloud based on results from tmod enrichment.
}
\details{
The tags will be generated based on results from tmod or any other
suitable data frame. The data frame must contain two numeric columns,
specified with "weights.col" and "pval.col", which will be
used to calculate the size and shade of the tags, respectively.
Furthermore, it has to contain a column with tags (parameter "tag.col",
by default "Title").

Any data frame can be used as long as it contains the specified columns.
}
\examples{
data(tmod)
fg <- getModuleMembers("LI.M127")[[1]]
bg <- tmod$gv
result <- tmodHGtest( fg, bg )
tmodTagcloud(result)
}
