% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{fake_county}
\alias{fake_county}
\title{Fake teacher roster dataset from OpenSDP}
\format{
A data frame with 39,339 rows and 38 variables:
\describe{
  \item{tid}{double: Teacher ID}
  \item{fake_data}{double: Record Is Simulated}
  \item{school_year}{double: School Year}
  \item{school_code}{double: School Code}
  \item{school_name}{character: School Name}
  \item{t_male}{double: Teacher Is Male}
  \item{t_race_ethnicity}{double: Teacher Race/Ethnicity}
  \item{t_job_area}{double: Teacher Assignment Type}
  \item{t_salary}{double: Monthly Salary}
  \item{t_nbpts}{double: Teacher Has National Board Certification}
  \item{t_tenured}{double: Teacher Is Tenured}
  \item{t_experience}{double: Years of Teaching Experience}
  \item{t_fte}{double: Teacher's FTE Status}
  \item{t_highest_degree}{double: Teacher's Highest Degree}
  \item{t_licensed_stem}{double: Teacher Is Licensed In STEM Field}
  \item{t_eval_obs}{double: Evaluation Summary Observation Score}
  \item{t_eval_growth}{double: Evaluation Summary Student Growth Score}
  \item{t_stay}{double: Teacher in Same School in Following Year}
  \item{t_transfer}{double: Teacher in Different School in Following Year}
  \item{t_leave}{double: Teacher Not Teaching in Fake County Schools in Following Year}
  \item{t_novice}{double: Teacher Is Novice First-Year Teacher}
  \item{t_new_hire}{double: Teacher Did Not Teach in Fake County in Prior Year}
  \item{sch_elem}{double: School Is Elementary School}
  \item{sch_middle}{double: School Is Middle School}
  \item{sch_high}{double: School Is High School}
  \item{sch_alternative}{double: School Is Alternative School}
  \item{sch_regular}{double: School Is Regular School}
  \item{sch_title_1}{double: School Is Title 1 School}
  \item{sch_magnet}{double: School Is Magnet School}
  \item{sch_vocational}{double: School is Vocational School}
  \item{sch_region}{double: School Region Code}
  \item{sch_calendar_type}{double: School Calendar Type}
  \item{sch_iep_pct}{double: School Special Education Student Share in 2012-15}
  \item{sch_minority_pct}{double: School Minority Student Share in 2012-15}
  \item{sch_frpl_pct}{double: School Free and Reduced Price Lunch Student Share in 2012-15}
  \item{sch_ela_avg}{double: School ELA Test Score Average in 2012-15 (in standard deviations)}
  \item{sch_math_avg}{double: School Math Test Score Average in 2012-15 (in standard deviations)}
  \item{sch_enroll_2015}{double: School Enrollment in 2015}
}
}
\source{
\url{https://github.com/OpenSDP/fake-county}, posted under a Creative Commons license.
}
\usage{
fake_county
}
\description{
The Fake County synthetic panel dataset contains approximately 40,000 records comprising four years of data with roughly 10,000 teachers per year. The dataset includes information about teacher demographics, teaching assignments, salary, credentials, experience, evaluation scores, and hiring and retention status. It also includes information about school types and average student characteristics for each school. There are no real teachers in the dataset, but it is based on real data. Fake County was developed as an offshoot of the Strategic Data Project's work on human capital diagnostics for school districts and state education departments, and can be used for teaching or collaboration. The data was synthesized using the R synthpop package.
}
\keyword{datasets}
