% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/player.R
\name{bart_player_game}
\alias{bart_player_game}
\title{Get Player Game Stats}
\usage{
bart_player_game(year = current_season(), stat = "all")
}
\arguments{
\item{year}{Defaults to current season (YYYY).}

\item{stat}{Indicates statistical split (see details).}
}
\value{
Returns a tibble with the number of columns dependent on the value
  supplied to the `stat` argument.
}
\description{
Returns detailed game-by-game player statistics on a variety of splits.
}
\details{
#' Data is split on three statistical types, explained below: \describe{
\item{box}{Returns basic box score stats; sorts by ppg.}
\item{shooting}{Returns play-by-play shooting splits; sorts by ppg.}
\item{adv}{Returns advanced metrics and possession-adjusted box score
statistics; sorts by recruiting rank.}}
}
\examples{
\donttest{bart_player_game(year=2022, stat='box')}

}
