% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bart_player_season.R
\name{bart_player_season}
\alias{bart_player_season}
\title{Get Player Season Stats}
\usage{
bart_player_season(
  year = current_season(),
  id = NULL,
  team = NULL,
  stat = NULL,
  load_all = FALSE,
  ...
)
}
\arguments{
\item{year}{Defaults to current season (YYYY).}

\item{id}{Filters to player ID}

\item{team}{Filters to team}

\item{stat}{Stat to return ('advanced', 'box', 'shooting')}

\item{load_all}{Load all available data (boolean); defaults to FALSE.}

\item{...}{Acceptable parameters for API. Used for function development}
}
\value{
Returns a tibble with the number of columns dependent on the value
  supplied to the `stat` argument.
}
\description{
Returns detailed, season-long player statistics on a variety of splits.
}
\details{
Data is split on three statistical types, explained below: \describe{
\item{box}{Returns basic box score stats; sorts by ppg.}
\item{shooting}{Returns play-by-play shooting splits; sorts by ppg.}
\item{advanced}{Returns advanced metrics and possession-adjusted box score
statistics; sorts by recruiting rank.} \item{all}{Used when `load_all` is
TRUE to return all data}}
}
\examples{
\donttest{try(bart_player_season(year=2019, stat='advanced'))}

}
