% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bart_tournament_prediction.R
\name{bart_tournament_prediction}
\alias{bart_tournament_prediction}
\title{T-Rank Tournament Prediction}
\usage{
bart_tournament_prediction(teams = NULL, date = NULL, sims = NULL, seed = NULL)
}
\arguments{
\item{teams}{List of teams arranged in scheduled order}

\item{date}{Date for tournament}

\item{sims}{Number of simulations to play}

\item{seed}{Seed to set for reproducible results}
}
\value{
Returns a tibble with four columns: \describe{
  \item{\code{team}}{character.} \item{\code{wins}}{integer.}
  \item{\code{finals}}{integer.} \item{\code{champ}}{integer.}}
}
\description{
Returns single-elimination tournament predictions using Barttorvik's
model
}
\details{
Given a list of teams arranged in scheduled order, function returns
tournament predictions for single-elimination tournaments. Teams must be
supplied as a character vector and in bracket order. In other words, if team
A plays team B and team C plays team D in round one, the function should be
supplied `teams=c('A', 'B', 'C', 'D')`.
}
\examples{
\donttest{try(bart_tournament_prediction(teams=c('Duke', 'North Carolina',
'Kansas', 'Villanova'), date='20220402', sims=10, seed=1))}

}
