% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calendar-options.R
\name{cal_week_options}
\alias{cal_week_options}
\title{Calendar Week Options}
\usage{
cal_week_options(
  cal,
  startDayOfWeek = NULL,
  daynames = NULL,
  narrowWeekend = NULL,
  workweek = NULL,
  showTimezoneCollapseButton = NULL,
  timezonesCollapsed = NULL,
  hourStart = NULL,
  hourEnd = NULL,
  scheduleView = TRUE,
  taskView = FALSE,
  ...
)
}
\arguments{
\item{cal}{A \code{\link[=calendar]{calendar()}} object.}

\item{startDayOfWeek}{Numeric. The start day of week.}

\item{daynames}{Vector. The day names in weekly and daily. Default values are 'Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'.}

\item{narrowWeekend}{Logical. Make weekend column narrow(1/2 width).}

\item{workweek}{Logical. Show only 5 days except for weekend.}

\item{showTimezoneCollapseButton}{Logical. Show a collapse button to close multiple timezones}

\item{timezonesCollapsed}{Logical. An initial multiple timezones collapsed state.}

\item{hourStart}{Numeric. Can limit of render hour start.}

\item{hourEnd}{Numeric. Can limit of render hour end.}

\item{scheduleView}{Show the all day and time grid in weekly, daily view.
The default value is \code{TRUE}. If the value is a vector, it can be \code{"allday"}, \code{"time"}.}

\item{taskView}{Show the milestone and task in weekly, daily view.
The default value is \code{FALSE}. If the value is a vector, it can be \code{"milestone"}, \code{"task"}.}

\item{...}{Additional options.}
}
\value{
A \code{calendar} htmlwidget.
}
\description{
Options for daily, weekly view.
}
\note{
Online JavaScript documentation: \url{https://github.com/nhn/tui.calendar/blob/main/docs/en/apis/options.md#week}
}
\examples{
# Change option for weekly view
calendar(view = "week") \%>\%
  cal_week_options(
    startDayOfWeek = 1,
    daynames = c("Dim", "Lun", "Mar", "Mer", "Jeu", "Ven", "Sam"),
    narrowWeekend = TRUE
  )
}
