% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny.R
\name{datagrid-shiny}
\alias{datagrid-shiny}
\alias{datagridOutput}
\alias{renderDatagrid}
\title{Shiny bindings for \code{\link[=datagrid]{datagrid()}}}
\usage{
datagridOutput(outputId, width = "100\%", height = "400px")

renderDatagrid(expr, env = parent.frame(), quoted = FALSE)
}
\arguments{
\item{outputId}{Output variable to read from.}

\item{width, height}{Must be a valid CSS unit (like \verb{100\%},
\verb{400px}, \code{auto}) or a number, which will be coerced to a
string and have \code{px} appended.}

\item{expr}{An expression that generates a calendar}

\item{env}{The environment in which to evaluate \code{expr}.}

\item{quoted}{Is \code{expr} a quoted expression (with \code{quote()})? This
is useful if you want to save an expression in a variable.}
}
\value{
Output element that can be included in UI. Render function to create output in server.
}
\description{
Output and render functions for using \code{\link[=datagrid]{datagrid()}} within Shiny
applications and interactive Rmd documents.
}
\section{Special inputs}{
The following \code{input} values will be accessible in the server:
\itemize{
\item \strong{input$outputId_data} : contain the data displayed in grid, only available when \code{datagrid(data_as_input = TRUE)} or when using \code{\link[=grid_editor]{grid_editor()}}
\item \strong{input$outputId_validation} : contain results of validation rules applied to data, only available when using \code{validation} argument in \code{\link[=grid_editor]{grid_editor()}}
}

These other inputs can be defined using other functions:
\itemize{
\item \emph{row selection}: giving row selected with checkboxes or radio buttons in \code{inputId} defined in \code{\link[=grid_selection_row]{grid_selection_row()}}
\item \emph{cell selection}: giving cell selected with mouse in \code{inputId} defined in \code{\link[=grid_selection_cell]{grid_selection_cell()}}
\item \emph{cell clicked}: giving row index and column name of cell clicked in \code{inputId} defined in \code{\link[=grid_click]{grid_click()}}
}
}

\examples{
library(shiny)
library(toastui)

ui <- fluidPage(
  tags$h2("datagrid shiny example"),
  tabsetPanel(
    tabPanel(
      title = "Fixed height",
      datagridOutput("default"),
      tags$b("CHECK HEIGHT")
    ),
    tabPanel(
      title = "Full height",
      datagridOutput("fullheight", height = "auto"),
      tags$b("CHECK HEIGHT")
    ),
    tabPanel(
      title = "Pagination",
      datagridOutput("pagination", height = "auto"),
      tags$b("CHECK HEIGHT")
    )
  )
)

server <- function(input, output, session) {

  output$default <- renderDatagrid({
    datagrid(rolling_stones_500)
  })

  output$fullheight <- renderDatagrid({
    datagrid(rolling_stones_500, bodyHeight = "auto")
  })

  output$pagination <- renderDatagrid({
    datagrid(rolling_stones_500, pagination = 15)
  })

}

if (interactive())
  shinyApp(ui, server)
}
