% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tag_tokens.r
\name{category_highlight_tokens}
\alias{category_highlight_tokens}
\title{Highlight tokens per category}
\usage{
category_highlight_tokens(
  tokens,
  category,
  labels = NULL,
  alpha = 0.4,
  colors = NULL,
  span_adjacent = F
)
}
\arguments{
\item{tokens}{A character vector of tokens}

\item{category}{A numeric vector with values representing category indices.}

\item{labels}{A character vector with labels for the categories}

\item{alpha}{Optionally, the alpha (transparency) can be specified, with 0 being fully transparent and 1 being
fully colored. This can be a vector to specify a different alpha for each value.}

\item{colors}{A character vector with color names for unique values of the value argument. Has to be the same length
as unique(na.omit(category))}

\item{span_adjacent}{If TRUE, include adjacent tokens with identical attributes within the same tag}
}
\value{
a character vector of color-tagged tokens
}
\description{
This is a convenience wrapper for tag_tokens() that can be used if tokens need to be colored per category
}
\examples{
tokens = c('token_1','token_2','token_3','token_4')
category = c(1,1,NA,2)
category_highlight_tokens(tokens, category)
}
