% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_stability.R
\name{table_stability}
\alias{table_stability}
\title{Table of stability indices}
\usage{
table_stability(
  data,
  trait,
  genotype,
  environment,
  lambda,
  normalize = FALSE,
  unit.correct = FALSE
)
}
\arguments{
\item{data}{a data frame containing trait, genotype and environment.}

\item{trait}{colname of a column containing a numeric vector of interested trait to be analyzed.}

\item{genotype}{colname of a column containing a character or factor vector labeling different genotypic varieties.}

\item{environment}{colname(s) of a column containing a character or factor vector labeling different environments,
if input is a vector containing multiple column names, then it will be merged into single environment column in the function.}

\item{lambda}{the minimal acceptable value of trait that the user expected from crop across environments. Lambda should between the ranges of trait vlaue.}

\item{normalize}{logical, default is \code{FALSE}, indicating whether stability indices should be normalized to the range from 0 to 1, where 1 refer to stable and 0 is unstable.}

\item{unit.correct}{logical, default is \code{FALSE}, returning the stability index with unit equals to squared unit of trait; when \code{TRUE}, returning stability index with the unit as same as unit of trait.}
}
\value{
a data table with multiple stability indices
}
\description{
\code{table_stability} export all the stability indices in the package.
}
\details{
Combine all stability indices in this package and export as a table, including mean trait, normality of the trait across environment.
}
\examples{
data(Data)
tb <- table_stability(
 data = Data,
 trait = "Yield",
 genotype = "Genotype",
 environment = "Environment",
 lambda = median(Data$Yield),
 normalize = TRUE,
 unit.correct=TRUE)
}
\references{
\insertRef{doering2018}{toolStability}
\insertRef{pinthus1973}{toolStability}
\insertRef{finlay1963}{toolStability}
\insertRef{eberhart1966}{toolStability}
\insertRef{wricke1962}{toolStability}
\insertRef{roemer1917}{toolStability}
\insertRef{hanson1970}{toolStability}
\insertRef{lin1988}{toolStability}
\insertRef{shukla1972}{toolStability}
\insertRef{nassar1987}{toolStability}
\insertRef{eskridge1990}{toolStability}
}
\seealso{
\code{\link{adjusted_coefficient_of_variation}}

\code{\link{coefficient_of_determination}}

\code{\link{coefficient_of_regression}}

\code{\link{deviation_mean_squares}}

\code{\link{ecovalence}}

\code{\link{environmental_variance}}

\code{\link{genotypic_stability}}

\code{\link{genotypic_superiority_measure}}

\code{\link{stability_variance}}

\code{\link{variance_of_rank}}

\code{\link{safety_first_index}}
}
\author{
Tien-Cheng Wang
}
\keyword{dynamic}
\keyword{nonparametric}
\keyword{probablistic}
\keyword{regression}
\keyword{static}
