% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_preprocessing.R
\name{log_transform_parameters}
\alias{log_transform_parameters}
\title{Log Transform Parameter Samples}
\usage{
log_transform_parameters(samples_file, output_file = NULL)
}
\arguments{
\item{samples_file}{Character. Path to the CSV file containing the parameter samples.}

\item{output_file}{Character. Optional path to save the transformed data as a new CSV file.}
}
\value{
A \code{data.frame} with the log-transformed parameters. If \code{output_file} is
specified, the data frame is also written to a file and returned invisibly.
}
\description{
Reads parameter samples from a CSV file and applies a log transformation to
specified parameter columns (e.g., N, k0, cooling_rate, c_repulsion).

\strong{Note}: As of version 2.0.0, this function is primarily for backward compatibility
with existing parameter files. The \code{initial_parameter_optimization()} function now
returns log-transformed parameters directly, eliminating the need for this separate
transformation step in the normal workflow.
}
\details{
This function is maintained for users who have existing parameter files from
older versions of the package or who need to work with parameter files that
contain original-scale parameters. In the current workflow:
\itemize{
\item \code{initial_parameter_optimization()} --> returns log-transformed parameters directly
\item \code{run_adaptive_sampling()} --> works with log-transformed parameters
\item \code{euclidean_embedding()} --> works with original-scale parameters
}

If you are working with the current workflow (using \code{Euclidify()} or calling
\code{initial_parameter_optimization()} directly), you typically do not need to call
this function.
}
\note{
\strong{Backward Compatibility Note}: This function is maintained for compatibility
with existing workflows and parameter files. For new workflows, consider using
\code{initial_parameter_optimization()} which returns log-transformed parameters directly.
}
\examples{
# This example uses a sample file included with the package.
sample_file <- system.file("extdata", "sample_params.csv", package = "topolow")

# Ensure the file exists before running the example
if (nzchar(sample_file)) {
  # Transform the data from the sample file and return as a data frame
  transformed_data <- log_transform_parameters(sample_file, output_file = NULL)

  # Display the first few rows of the transformed data
  print(head(transformed_data))
}

}
