% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_any.R
\name{list_any}
\alias{list_any}
\title{Read multiple files into a list with your favorite reader function.}
\usage{
list_any(path = ".", .f, regexp = NULL, ignore.case = FALSE,
  invert = FALSE, ...)
}
\arguments{
\item{path}{A character vector of one or more paths.}

\item{.f}{A function able to read the desired file format.}

\item{regexp}{A regular expression (e.g. \code{[.]csv$}) passed on to \code{\link[=grep]{grep()}} to filter paths.}

\item{ignore.case}{if \code{FALSE}, the pattern matching is \emph{case
      sensitive} and if \code{TRUE}, case is ignored during matching.}

\item{invert}{If \code{TRUE} return files which do \emph{not} match}

\item{...}{Additional arguments passed to \link{grep}.}
}
\value{
A list.
}
\description{
Read multiple files into a list with your favorite reader function.
}
\examples{
tor_example()

path <- tor_example("csv")
dir(path)

list_any(path, read.csv)

list_any(path, ~ read.csv(.x, stringsAsFactors = FALSE))

(path_mixed <- tor_example("mixed"))
dir(path_mixed)

list_any(
  path_mixed, ~ get(load(.x)),
  regexp = "[.]csv$",
  invert = TRUE
)

list_any(
  path_mixed, ~ get(load(.x)),
  "[.]Rdata$",
  ignore.case = TRUE
)
}
\seealso{
Other general functions to import data: \code{\link{list_csv}},
  \code{\link{load_csv}}
}
\concept{general functions to import data}
