% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_squeeze}
\alias{torch_squeeze}
\title{Squeeze}
\usage{
torch_squeeze(self, dim)
}
\arguments{
\item{self}{(Tensor) the input tensor.}

\item{dim}{(int, optional) if given, the input will be squeezed only in           this dimension}
}
\description{
Squeeze
}
\note{
The returned tensor shares the storage with the input tensor,
so changing the contents of one will change the contents of the other.
}
\section{squeeze(input, dim=NULL, out=NULL) -> Tensor }{


Returns a tensor with all the dimensions of \code{input} of size \code{1} removed.

For example, if \code{input} is of shape:
\eqn{(A \times 1 \times B \times C \times 1 \times D)} then the \code{out} tensor
will be of shape: \eqn{(A \times B \times C \times D)}.

When \code{dim} is given, a squeeze operation is done only in the given
dimension. If \code{input} is of shape: \eqn{(A \times 1 \times B)},
\code{squeeze(input, 0)} leaves the tensor unchanged, but \code{squeeze(input, 1)}
will squeeze the tensor to the shape \eqn{(A \times B)}.
}

\examples{
if (torch_is_installed()) {

x = torch_zeros(c(2, 1, 2, 1, 2))
x
y = torch_squeeze(x)
y
y = torch_squeeze(x, 1)
y
y = torch_squeeze(x, 2)
y
}
}
