% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linalg.R
\name{linalg_qr}
\alias{linalg_qr}
\title{Computes the QR decomposition of a matrix.}
\usage{
linalg_qr(A, mode = "reduced")
}
\arguments{
\item{A}{(Tensor): tensor of shape \verb{(*, m, n)} where \code{*} is zero or more batch dimensions.}

\item{mode}{(str, optional): one of \code{'reduced'}, \code{'complete'}, \code{'r'}.
Controls the shape of the returned tensors. Default: \code{'reduced'}.}
}
\value{
A list \verb{(Q, R)}.
}
\description{
Letting \teqn{\mathbb{K}} be \teqn{\mathbb{R}} or \teqn{\mathbb{C}},
the \strong{full QR decomposition} of a matrix
\teqn{A \in \mathbb{K}^{m \times n}} is defined as
}
\details{
\Sexpr[results=rd, stage=build]{torch:::math_to_rd("
A = QR\\\\mathrlap{\\\\qquad Q \\\\in \\\\mathbb{K}^{m \\\\times m}, R \\\\in \\\\mathbb{K}^{m \\\\times n}}
")}

where \teqn{Q} is orthogonal in the real case and unitary in the complex case, and \teqn{R} is upper triangular.
When \code{m > n} (tall matrix), as \code{R} is upper triangular, its last \code{m - n} rows are zero.
In this case, we can drop the last \code{m - n} columns of \code{Q} to form the
\strong{reduced QR decomposition}:

\Sexpr[results=rd, stage=build]{torch:::math_to_rd("
A = QR\\\\mathrlap{\\\\qquad Q \\\\in \\\\mathbb{K}^{m \\\\times n}, R \\\\in \\\\mathbb{K}^{n \\\\times n}}
")}

The reduced QR decomposition agrees with the full QR decomposition when \code{n >= m} (wide matrix).
Supports input of float, double, cfloat and cdouble dtypes.
Also supports batches of matrices, and if \code{A} is a batch of matrices then
the output has the same batch dimensions.
The parameter \code{mode} chooses between the full and reduced QR decomposition.

If \code{A} has shape \verb{(*, m, n)}, denoting \code{k = min(m, n)}
\itemize{
\item \code{mode = 'reduced'} (default): Returns \verb{(Q, R)} of shapes \verb{(*, m, k)}, \verb{(*, k, n)} respectively.
\item \code{mode = 'complete'}: Returns \verb{(Q, R)} of shapes \verb{(*, m, m)}, \verb{(*, m, n)} respectively.
\item \code{mode = 'r'}: Computes only the reduced \code{R}. Returns \verb{(Q, R)} with \code{Q} empty and \code{R} of shape \verb{(*, k, n)}.
}
}
\examples{
if (torch_is_installed()) {
a <- torch_tensor(rbind(c(12., -51, 4), c(6, 167, -68), c(-4, 24, -41)))
qr <- linalg_qr(a)

torch_mm(qr[[1]], qr[[2]])$round()
torch_mm(qr[[1]]$t(), qr[[1]])$round()
}
}
\seealso{
Other linalg: 
\code{\link{linalg_cholesky_ex}()},
\code{\link{linalg_cholesky}()},
\code{\link{linalg_det}()},
\code{\link{linalg_eigh}()},
\code{\link{linalg_eigvalsh}()},
\code{\link{linalg_eigvals}()},
\code{\link{linalg_eig}()},
\code{\link{linalg_householder_product}()},
\code{\link{linalg_inv_ex}()},
\code{\link{linalg_inv}()},
\code{\link{linalg_lstsq}()},
\code{\link{linalg_matrix_norm}()},
\code{\link{linalg_matrix_power}()},
\code{\link{linalg_matrix_rank}()},
\code{\link{linalg_multi_dot}()},
\code{\link{linalg_norm}()},
\code{\link{linalg_pinv}()},
\code{\link{linalg_slogdet}()},
\code{\link{linalg_solve_triangular}()},
\code{\link{linalg_solve}()},
\code{\link{linalg_svdvals}()},
\code{\link{linalg_svd}()},
\code{\link{linalg_tensorinv}()},
\code{\link{linalg_tensorsolve}()},
\code{\link{linalg_vector_norm}()}
}
\concept{linalg}
