% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optim-rmsprop.R
\name{optim_rmsprop}
\alias{optim_rmsprop}
\title{RMSprop optimizer}
\usage{
optim_rmsprop(
  params,
  lr = 0.01,
  alpha = 0.99,
  eps = 1e-08,
  weight_decay = 0,
  momentum = 0,
  centered = FALSE
)
}
\arguments{
\item{params}{(iterable): iterable of parameters to optimize or list defining parameter groups}

\item{lr}{(float, optional): learning rate (default: 1e-2)}

\item{alpha}{(float, optional): smoothing constant (default: 0.99)}

\item{eps}{(float, optional): term added to the denominator to improve
numerical stability (default: 1e-8)}

\item{weight_decay}{optional weight decay penalty. (default: 0)}

\item{momentum}{(float, optional): momentum factor (default: 0)}

\item{centered}{(bool, optional) : if \code{TRUE}, compute the centered RMSProp,
the gradient is normalized by an estimation of its variance
weight_decay (float, optional): weight decay (L2 penalty) (default: 0)}
}
\description{
Proposed by G. Hinton in his course.
}
\note{
The centered version first appears in
\href{https://arxiv.org/pdf/1308.0850v5}{Generating Sequences With Recurrent Neural Networks}.
The implementation here takes the square root of the gradient average before
adding epsilon (note that TensorFlow interchanges these two operations). The effective
learning rate is thus \eqn{\alpha/(\sqrt{v} + \epsilon)} where \eqn{\alpha}
is the scheduled learning rate and \eqn{v} is the weighted moving average
of the squared gradient.

Update rule:

\deqn{
\theta_{t+1} = \theta_{t} - \frac{\eta }{\sqrt{{E[g^2]}_{t} + \epsilon}} * g_{t}
}
}
\section{Warning}{
If you need to move a model to GPU via \verb{$cuda()}, please do so before
constructing optimizers for it. Parameters of a model after \verb{$cuda()}
will be different objects from those before the call. In general, you
should make sure that the objects pointed to by model parameters subject
to optimization remain the same over the whole lifecycle of optimizer
creation and usage.
}

