% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nnf-activation.R
\name{nnf_log_softmax}
\alias{nnf_log_softmax}
\title{Log_softmax}
\usage{
nnf_log_softmax(input, dim = NULL, dtype = NULL)
}
\arguments{
\item{input}{(Tensor) input}

\item{dim}{(int) A dimension along which log_softmax will be computed.}

\item{dtype}{(\code{torch.dtype}, optional) the desired data type of returned tensor.
If specified, the input tensor is casted to \code{dtype} before the operation
is performed. This is useful for preventing data type overflows.
Default: \code{NULL}.}
}
\description{
Applies a softmax followed by a logarithm.
}
\details{
While mathematically equivalent to log(softmax(x)), doing these two
operations separately is slower, and numerically unstable. This function
uses an alternative formulation to compute the output and gradient correctly.
}
