% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_cummax}
\alias{torch_cummax}
\title{Cummax}
\usage{
torch_cummax(self, dim)
}
\arguments{
\item{self}{(Tensor) the input tensor.}

\item{dim}{(int) the dimension to do the operation over}
}
\description{
Cummax
}
\section{cummax(input, dim) -> (Tensor, LongTensor) }{


Returns a namedtuple \verb{(values, indices)} where \code{values} is the cumulative maximum of
elements of \code{input} in the dimension \code{dim}. And \code{indices} is the index
location of each maximum value found in the dimension \code{dim}.

\deqn{
    y_i = max(x_1, x_2, x_3, \dots, x_i)
}
}

\examples{
if (torch_is_installed()) {

a = torch_randn(c(10))
a
torch_cummax(a, dim=1)
}
}
