% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotArea.R
\name{plotArea}
\alias{plotArea}
\title{Plotting topics over time as stacked areas below plotted lines.}
\usage{
plotArea(
  ldaresult,
  ldaID,
  select = NULL,
  tnames = NULL,
  threshold = NULL,
  meta,
  unit = "quarter",
  xunit = "year",
  color = NULL,
  sort = TRUE,
  legend = NULL,
  legendLimit = 0,
  peak = 0,
  file
)
}
\arguments{
\item{ldaresult}{LDA result object}

\item{ldaID}{Character vector including IDs of the texts}

\item{select}{Selects all topics if parameter is null. Otherwise vector of integers or topic label. Only topics belonging to that numbers, and labels respectively would be plotted.}

\item{tnames}{Character vector of topic labels. It must have same length than number of topics in the model.}

\item{threshold}{Numeric: Treshold between 0 and 1. Topics would only be used if at least one time unit exist with a topic proportion above the treshold}

\item{meta}{The meta data for the texts or a date-string.}

\item{unit}{Time unit for x-axis. Possible units are \code{"bimonth"}, \code{"quarter"}, \code{"season"},
\code{"halfyear"}, \code{"year"}, for more units see \code{\link[lubridate]{round_date}}}

\item{xunit}{Time unit for tiks on the x-axis. For possible units see \code{\link[lubridate]{round_date}}}

\item{color}{Color vector. Color vector would be replicated if the number of plotted topics is bigger than length of the vector.}

\item{sort}{Logical: Should the topics be sorted by topic proportion?}

\item{legend}{Position of legend. If \code{NULL} (default), no legend will be plotted}

\item{legendLimit}{Numeric between 0 (default) and 1. Only Topics with proportions above this limit appear in the legend.}

\item{peak}{Numeric between 0 (default) and 1. Label peaks above \code{peak}. For each Topic every area which are at least once above \code{peak} will e labeled. An area ends if the topic proportion is under 1 percent.}

\item{file}{Character: File path if a pdf should be created}
}
\value{
List of two matrices. \code{rel} contains the topic proportions over time, \code{relcum} contains the cumulated topic proportions
}
\description{
Creates a stacked area plot of all or selected topics.
}
\details{
This function is useful to visualize the volume of topics and to show trends over time.
}
\examples{
\donttest{
data(politics)
poliClean <- cleanTexts(politics)
words10 <- makeWordlist(text=poliClean$text)
words10 <- words10$words[words10$wordtable > 10]
poliLDA <- LDAprep(text=poliClean$text, vocab=words10)
LDAresult <- LDAgen(documents=poliLDA, K=10, vocab=words10)
plotArea(ldaresult=LDAresult, ldaID=names(poliLDA), meta=politics$meta)

plotArea(ldaresult=LDAresult, ldaID=names(poliLDA), meta=politics$meta, select=c(1,3,5))
}
}
